"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def delete(
    hub, ctx, api_id: str, request_parameter_key: str, route_id: str
) -> None:
    r"""
    **Autogenerated function**

    Deletes a route request parameter.

    Args:
        api_id(str): The API identifier.
        request_parameter_key(str): The route request parameter key.
        route_id(str): The route ID.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.route.request_parameter.delete(
                ctx, api_id=value, request_parameter_key=value, route_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.route.request_parameter.delete api_id=value, request_parameter_key=value, route_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="delete_route_request_parameter",
        op_kwargs={
            "ApiId": api_id,
            "RequestParameterKey": request_parameter_key,
            "RouteId": route_id,
        },
    )
