"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    api_id: str,
    route_key: str,
    api_key_required: bool = None,
    authorization_scopes: List = None,
    authorization_type: str = None,
    authorizer_id: str = None,
    model_selection_expression: str = None,
    operation_name: str = None,
    request_models: Dict = None,
    request_parameters: Dict = None,
    route_response_selection_expression: str = None,
    target: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a Route for an API.

    Args:
        api_id(str): The API identifier.
        api_key_required(bool, optional): Specifies whether an API key is required for the route. Supported only for WebSocket APIs. Defaults to None.
        authorization_scopes(List, optional): The authorization scopes supported by this route. Defaults to None.
        authorization_type(str, optional): The authorization type for the route. For WebSocket APIs, valid values are NONE for open access, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer For HTTP APIs, valid values are NONE for open access, JWT for using JSON Web Tokens, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer. Defaults to None.
        authorizer_id(str, optional): The identifier of the Authorizer resource to be associated with this route. The authorizer identifier is generated by API Gateway when you created the authorizer. Defaults to None.
        model_selection_expression(str, optional): The model selection expression for the route. Supported only for WebSocket APIs. Defaults to None.
        operation_name(str, optional): The operation name for the route. Defaults to None.
        request_models(Dict, optional): The request models for the route. Supported only for WebSocket APIs. Defaults to None.
        request_parameters(Dict, optional): The request parameters for the route. Supported only for WebSocket APIs. Defaults to None.
        route_key(str): The route key for the route.
        route_response_selection_expression(str, optional): The route response selection expression for the route. Supported only for WebSocket APIs. Defaults to None.
        target(str, optional): The target for the route. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.route.init.create(
                ctx, api_id=value, route_key=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.route.init.create api_id=value, route_key=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="create_route",
        op_kwargs={
            "ApiId": api_id,
            "ApiKeyRequired": api_key_required,
            "AuthorizationScopes": authorization_scopes,
            "AuthorizationType": authorization_type,
            "AuthorizerId": authorizer_id,
            "ModelSelectionExpression": model_selection_expression,
            "OperationName": operation_name,
            "RequestModels": request_models,
            "RequestParameters": request_parameters,
            "RouteKey": route_key,
            "RouteResponseSelectionExpression": route_response_selection_expression,
            "Target": target,
        },
    )


async def delete(hub, ctx, api_id: str, route_id: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a Route.

    Args:
        api_id(str): The API identifier.
        route_id(str): The route ID.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.route.init.delete(
                ctx, api_id=value, route_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.route.init.delete api_id=value, route_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="delete_route",
        op_kwargs={"ApiId": api_id, "RouteId": route_id},
    )


async def get(hub, ctx, api_id: str, route_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets a Route.

    Args:
        api_id(str): The API identifier.
        route_id(str): The route ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.route.init.get(ctx, api_id=value, route_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.route.init.get api_id=value, route_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="get_route",
        op_kwargs={"ApiId": api_id, "RouteId": route_id},
    )


async def get_all(
    hub, ctx, api_id: str, max_results: str = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Gets the Routes for an API.

    Args:
        api_id(str): The API identifier.
        max_results(str, optional): The maximum number of elements to be returned for this resource. Defaults to None.
        next_token(str, optional): The next page of elements from this collection. Not valid for the last element of the collection. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.route.init.get_all(ctx, api_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.route.init.get_all api_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="get_routes",
        op_kwargs={"ApiId": api_id, "MaxResults": max_results, "NextToken": next_token},
    )


async def update(
    hub,
    ctx,
    api_id: str,
    route_id: str,
    api_key_required: bool = None,
    authorization_scopes: List = None,
    authorization_type: str = None,
    authorizer_id: str = None,
    model_selection_expression: str = None,
    operation_name: str = None,
    request_models: Dict = None,
    request_parameters: Dict = None,
    route_key: str = None,
    route_response_selection_expression: str = None,
    target: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a Route.

    Args:
        api_id(str): The API identifier.
        api_key_required(bool, optional): Specifies whether an API key is required for the route. Supported only for WebSocket APIs. Defaults to None.
        authorization_scopes(List, optional): The authorization scopes supported by this route. Defaults to None.
        authorization_type(str, optional): The authorization type for the route. For WebSocket APIs, valid values are NONE for open access, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer For HTTP APIs, valid values are NONE for open access, JWT for using JSON Web Tokens, AWS_IAM for using AWS IAM permissions, and CUSTOM for using a Lambda authorizer. Defaults to None.
        authorizer_id(str, optional): The identifier of the Authorizer resource to be associated with this route. The authorizer identifier is generated by API Gateway when you created the authorizer. Defaults to None.
        model_selection_expression(str, optional): The model selection expression for the route. Supported only for WebSocket APIs. Defaults to None.
        operation_name(str, optional): The operation name for the route. Defaults to None.
        request_models(Dict, optional): The request models for the route. Supported only for WebSocket APIs. Defaults to None.
        request_parameters(Dict, optional): The request parameters for the route. Supported only for WebSocket APIs. Defaults to None.
        route_id(str): The route ID.
        route_key(str, optional): The route key for the route. Defaults to None.
        route_response_selection_expression(str, optional): The route response selection expression for the route. Supported only for WebSocket APIs. Defaults to None.
        target(str, optional): The target for the route. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.route.init.update(
                ctx, api_id=value, route_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.route.init.update api_id=value, route_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="update_route",
        op_kwargs={
            "ApiId": api_id,
            "ApiKeyRequired": api_key_required,
            "AuthorizationScopes": authorization_scopes,
            "AuthorizationType": authorization_type,
            "AuthorizerId": authorizer_id,
            "ModelSelectionExpression": model_selection_expression,
            "OperationName": operation_name,
            "RequestModels": request_models,
            "RequestParameters": request_parameters,
            "RouteId": route_id,
            "RouteKey": route_key,
            "RouteResponseSelectionExpression": route_response_selection_expression,
            "Target": target,
        },
    )
