"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, api_id: str, model_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets a model template.

    Args:
        api_id(str): The API identifier.
        model_id(str): The model ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.model.template.get(
                ctx, api_id=value, model_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.model.template.get api_id=value, model_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="get_model_template",
        op_kwargs={"ApiId": api_id, "ModelId": model_id},
    )
