"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    api_id: str,
    name: str,
    schema: str,
    content_type: str = None,
    description: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a Model for an API.

    Args:
        api_id(str): The API identifier.
        content_type(str, optional): The content-type for the model, for example, "application/json". Defaults to None.
        description(str, optional): The description of the model. Defaults to None.
        name(str): The name of the model. Must be alphanumeric.
        schema(str): The schema for the model. For application/json models, this should be JSON schema draft 4 model.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.model.init.create(
                ctx, api_id=value, name=value, schema=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.model.init.create api_id=value, name=value, schema=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="create_model",
        op_kwargs={
            "ApiId": api_id,
            "ContentType": content_type,
            "Description": description,
            "Name": name,
            "Schema": schema,
        },
    )


async def delete(hub, ctx, api_id: str, model_id: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a Model.

    Args:
        api_id(str): The API identifier.
        model_id(str): The model ID.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.model.init.delete(
                ctx, api_id=value, model_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.model.init.delete api_id=value, model_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="delete_model",
        op_kwargs={"ApiId": api_id, "ModelId": model_id},
    )


async def get(hub, ctx, api_id: str, model_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets a Model.

    Args:
        api_id(str): The API identifier.
        model_id(str): The model ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.model.init.get(ctx, api_id=value, model_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.model.init.get api_id=value, model_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="get_model",
        op_kwargs={"ApiId": api_id, "ModelId": model_id},
    )


async def get_all(
    hub, ctx, api_id: str, max_results: str = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Gets the Models for an API.

    Args:
        api_id(str): The API identifier.
        max_results(str, optional): The maximum number of elements to be returned for this resource. Defaults to None.
        next_token(str, optional): The next page of elements from this collection. Not valid for the last element of the collection. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.model.init.get_all(ctx, api_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.model.init.get_all api_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="get_models",
        op_kwargs={"ApiId": api_id, "MaxResults": max_results, "NextToken": next_token},
    )


async def update(
    hub,
    ctx,
    api_id: str,
    model_id: str,
    content_type: str = None,
    description: str = None,
    name: str = None,
    schema: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a Model.

    Args:
        api_id(str): The API identifier.
        content_type(str, optional): The content-type for the model, for example, "application/json". Defaults to None.
        description(str, optional): The description of the model. Defaults to None.
        model_id(str): The model ID.
        name(str, optional): The name of the model. Defaults to None.
        schema(str, optional): The schema for the model. For application/json models, this should be JSON schema draft 4 model. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.model.init.update(
                ctx, api_id=value, model_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.model.init.update api_id=value, model_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="update_model",
        op_kwargs={
            "ApiId": api_id,
            "ContentType": content_type,
            "Description": description,
            "ModelId": model_id,
            "Name": name,
            "Schema": schema,
        },
    )
