"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    api_id: str,
    integration_id: str,
    integration_response_key: str,
    content_handling_strategy: str = None,
    response_parameters: Dict = None,
    response_templates: Dict = None,
    template_selection_expression: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an IntegrationResponses.

    Args:
        api_id(str): The API identifier.
        content_handling_strategy(str, optional): Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors: CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob. CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string. If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification. Defaults to None.
        integration_id(str): The integration ID.
        integration_response_key(str): The integration response key.
        response_parameters(Dict, optional): A key-value map specifying response parameters that are passed to the method response from the backend. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of method.response.header.{name}, where {name} is a valid and unique header name. The mapped non-static value must match the pattern of integration.response.header.{name} or integration.response.body.{JSON-expression}, where {name} is a valid and unique response header name and {JSON-expression} is a valid JSON expression without the $ prefix. Defaults to None.
        response_templates(Dict, optional): The collection of response templates for the integration response as a string-to-string map of key-value pairs. Response templates are represented as a key/value map, with a content-type as the key and a template as the value. Defaults to None.
        template_selection_expression(str, optional): The template selection expression for the integration response. Supported only for WebSocket APIs. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.integration.response.create(
                ctx, api_id=value, integration_id=value, integration_response_key=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.integration.response.create api_id=value, integration_id=value, integration_response_key=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="create_integration_response",
        op_kwargs={
            "ApiId": api_id,
            "ContentHandlingStrategy": content_handling_strategy,
            "IntegrationId": integration_id,
            "IntegrationResponseKey": integration_response_key,
            "ResponseParameters": response_parameters,
            "ResponseTemplates": response_templates,
            "TemplateSelectionExpression": template_selection_expression,
        },
    )


async def delete(
    hub, ctx, api_id: str, integration_id: str, integration_response_id: str
) -> None:
    r"""
    **Autogenerated function**

    Deletes an IntegrationResponses.

    Args:
        api_id(str): The API identifier.
        integration_id(str): The integration ID.
        integration_response_id(str): The integration response ID.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.integration.response.delete(
                ctx, api_id=value, integration_id=value, integration_response_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.integration.response.delete api_id=value, integration_id=value, integration_response_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="delete_integration_response",
        op_kwargs={
            "ApiId": api_id,
            "IntegrationId": integration_id,
            "IntegrationResponseId": integration_response_id,
        },
    )


async def get(
    hub, ctx, api_id: str, integration_id: str, integration_response_id: str
) -> Dict:
    r"""
    **Autogenerated function**

    Gets an IntegrationResponses.

    Args:
        api_id(str): The API identifier.
        integration_id(str): The integration ID.
        integration_response_id(str): The integration response ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.integration.response.get(
                ctx, api_id=value, integration_id=value, integration_response_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.integration.response.get api_id=value, integration_id=value, integration_response_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="get_integration_response",
        op_kwargs={
            "ApiId": api_id,
            "IntegrationId": integration_id,
            "IntegrationResponseId": integration_response_id,
        },
    )


async def get_all(
    hub,
    ctx,
    api_id: str,
    integration_id: str,
    max_results: str = None,
    next_token: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets the IntegrationResponses for an Integration.

    Args:
        api_id(str): The API identifier.
        integration_id(str): The integration ID.
        max_results(str, optional): The maximum number of elements to be returned for this resource. Defaults to None.
        next_token(str, optional): The next page of elements from this collection. Not valid for the last element of the collection. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.integration.response.get_all(
                ctx, api_id=value, integration_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.integration.response.get_all api_id=value, integration_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="get_integration_responses",
        op_kwargs={
            "ApiId": api_id,
            "IntegrationId": integration_id,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def update(
    hub,
    ctx,
    api_id: str,
    integration_id: str,
    integration_response_id: str,
    content_handling_strategy: str = None,
    integration_response_key: str = None,
    response_parameters: Dict = None,
    response_templates: Dict = None,
    template_selection_expression: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates an IntegrationResponses.

    Args:
        api_id(str): The API identifier.
        content_handling_strategy(str, optional): Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors: CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob. CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string. If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification. Defaults to None.
        integration_id(str): The integration ID.
        integration_response_id(str): The integration response ID.
        integration_response_key(str, optional): The integration response key. Defaults to None.
        response_parameters(Dict, optional): A key-value map specifying response parameters that are passed to the method response from the backend. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of method.response.header.{name}
               , where name is a valid and unique header name. The mapped non-static value must match the pattern of integration.response.header.{name}
                or integration.response.body.{JSON-expression}
               , where
                  {name}
                is a valid and unique response header name and
                  {JSON-expression}
                is a valid JSON expression without the $ prefix. Defaults to None.
        response_templates(Dict, optional): The collection of response templates for the integration response as a string-to-string map of key-value pairs. Response templates are represented as a key/value map, with a content-type as the key and a template as the value. Defaults to None.
        template_selection_expression(str, optional): The template selection expression for the integration response. Supported only for WebSocket APIs. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.integration.response.update(
                ctx, api_id=value, integration_id=value, integration_response_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.integration.response.update api_id=value, integration_id=value, integration_response_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="update_integration_response",
        op_kwargs={
            "ApiId": api_id,
            "ContentHandlingStrategy": content_handling_strategy,
            "IntegrationId": integration_id,
            "IntegrationResponseId": integration_response_id,
            "IntegrationResponseKey": integration_response_key,
            "ResponseParameters": response_parameters,
            "ResponseTemplates": response_templates,
            "TemplateSelectionExpression": template_selection_expression,
        },
    )
