"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub,
    ctx,
    api_id: str,
    integration_type: str,
    connection_id: str = None,
    connection_type: str = None,
    content_handling_strategy: str = None,
    credentials_arn: str = None,
    description: str = None,
    integration_method: str = None,
    integration_subtype: str = None,
    integration_uri: str = None,
    passthrough_behavior: str = None,
    payload_format_version: str = None,
    request_parameters: Dict = None,
    request_templates: Dict = None,
    response_parameters: Dict = None,
    template_selection_expression: str = None,
    timeout_in_millis: int = None,
    tls_config: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an Integration.

    Args:
        api_id(str): The API identifier.
        connection_id(str, optional): The ID of the VPC link for a private integration. Supported only for HTTP APIs. Defaults to None.
        connection_type(str, optional): The type of the network connection to the integration endpoint. Specify INTERNET for connections through the public routable internet or VPC_LINK for private connections between API Gateway and resources in a VPC. The default value is INTERNET. Defaults to None.
        content_handling_strategy(str, optional): Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors: CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob. CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string. If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification. Defaults to None.
        credentials_arn(str, optional): Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, specify null. Defaults to None.
        description(str, optional): The description of the integration. Defaults to None.
        integration_method(str, optional): Specifies the integration's HTTP method type. Defaults to None.
        integration_subtype(str, optional): Supported only for HTTP API AWS_PROXY integrations. Specifies the AWS service action to invoke. To learn more, see Integration subtype reference. Defaults to None.
        integration_type(str): The integration type of an integration. One of the following: AWS: for integrating the route or method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration. Supported only for WebSocket APIs. AWS_PROXY: for integrating the route or method request with a Lambda function or other AWS service action. This integration is also referred to as a Lambda proxy integration. HTTP: for integrating the route or method request with an HTTP endpoint. This integration is also referred to as the HTTP custom integration. Supported only for WebSocket APIs. HTTP_PROXY: for integrating the route or method request with an HTTP endpoint, with the client request passed through as-is. This is also referred to as HTTP proxy integration. For HTTP API private integrations, use an HTTP_PROXY integration. MOCK: for integrating the route or method request with API Gateway as a "loopback" endpoint without invoking any backend. Supported only for WebSocket APIs.
        integration_uri(str, optional): For a Lambda integration, specify the URI of a Lambda function. For an HTTP integration, specify a fully-qualified URL. For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service. If you specify the ARN of an AWS Cloud Map service, API Gateway uses DiscoverInstances to identify resources. You can use query parameters to target specific resources. To learn more, see DiscoverInstances. For private integrations, all resources must be owned by the same AWS account. Defaults to None.
        passthrough_behavior(str, optional): Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource. There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER. Supported only for WebSocket APIs. WHEN_NO_MATCH passes the request body for unmapped content types through to the integration backend without transformation. NEVER rejects unmapped content types with an HTTP 415 Unsupported Media Type response. WHEN_NO_TEMPLATES allows pass-through when the integration has no content types mapped to templates. However, if there is at least one content type defined, unmapped content types will be rejected with the same HTTP 415 Unsupported Media Type response. Defaults to None.
        payload_format_version(str, optional): Specifies the format of the payload sent to an integration. Required for HTTP APIs. Defaults to None.
        request_parameters(Dict, optional): For WebSocket APIs, a key-value map specifying request parameters that are passed from the method request to the backend. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the backend. The method request parameter value must match the pattern of method.request.{location}.{name}
               , where
                  {location}
                is querystring, path, or header; and
                  {name}
                must be a valid and unique method request parameter name. For HTTP API integrations with a specified integrationSubtype, request parameters are a key-value map specifying parameters that are passed to AWS_PROXY integrations. You can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see Working with AWS service integrations for HTTP APIs. For HTTP API integrations without a specified integrationSubtype request parameters are a key-value map specifying how to transform HTTP requests before sending them to the backend. The key should follow the pattern <action>:<header|querystring|path>.<location> where action can be append, overwrite or remove. For values, you can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see Transforming API requests and responses. Defaults to None.
        request_templates(Dict, optional): Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value. Supported only for WebSocket APIs. Defaults to None.
        response_parameters(Dict, optional): Supported only for HTTP APIs. You use response parameters to transform the HTTP response from a backend integration before returning the response to clients. Specify a key-value map from a selection key to response parameters. The selection key must be a valid HTTP status code within the range of 200-599. Response parameters are a key-value map. The key must match pattern <action>:<header>.<location> or overwrite.statuscode. The action can be append, overwrite or remove. The value can be a static value, or map to response data, stage variables, or context variables that are evaluated at runtime. To learn more, see Transforming API requests and responses. Defaults to None.
        template_selection_expression(str, optional): The template selection expression for the integration. Defaults to None.
        timeout_in_millis(int, optional): Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for HTTP APIs. The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs. Defaults to None.
        tls_config(Dict, optional): The TLS configuration for a private integration. If you specify a TLS configuration, private integration traffic uses the HTTPS protocol. Supported only for HTTP APIs. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.integration.init.create(
                ctx, api_id=value, integration_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.integration.init.create api_id=value, integration_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="create_integration",
        op_kwargs={
            "ApiId": api_id,
            "ConnectionId": connection_id,
            "ConnectionType": connection_type,
            "ContentHandlingStrategy": content_handling_strategy,
            "CredentialsArn": credentials_arn,
            "Description": description,
            "IntegrationMethod": integration_method,
            "IntegrationSubtype": integration_subtype,
            "IntegrationType": integration_type,
            "IntegrationUri": integration_uri,
            "PassthroughBehavior": passthrough_behavior,
            "PayloadFormatVersion": payload_format_version,
            "RequestParameters": request_parameters,
            "RequestTemplates": request_templates,
            "ResponseParameters": response_parameters,
            "TemplateSelectionExpression": template_selection_expression,
            "TimeoutInMillis": timeout_in_millis,
            "TlsConfig": tls_config,
        },
    )


async def delete(hub, ctx, api_id: str, integration_id: str) -> None:
    r"""
    **Autogenerated function**

    Deletes an Integration.

    Args:
        api_id(str): The API identifier.
        integration_id(str): The integration ID.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.integration.init.delete(
                ctx, api_id=value, integration_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.integration.init.delete api_id=value, integration_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="delete_integration",
        op_kwargs={"ApiId": api_id, "IntegrationId": integration_id},
    )


async def get(hub, ctx, api_id: str, integration_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets an Integration.

    Args:
        api_id(str): The API identifier.
        integration_id(str): The integration ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.integration.init.get(
                ctx, api_id=value, integration_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.integration.init.get api_id=value, integration_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="get_integration",
        op_kwargs={"ApiId": api_id, "IntegrationId": integration_id},
    )


async def get_all(
    hub, ctx, api_id: str, max_results: str = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Gets the Integrations for an API.

    Args:
        api_id(str): The API identifier.
        max_results(str, optional): The maximum number of elements to be returned for this resource. Defaults to None.
        next_token(str, optional): The next page of elements from this collection. Not valid for the last element of the collection. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.integration.init.get_all(ctx, api_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.integration.init.get_all api_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="get_integrations",
        op_kwargs={"ApiId": api_id, "MaxResults": max_results, "NextToken": next_token},
    )


async def update(
    hub,
    ctx,
    api_id: str,
    integration_id: str,
    connection_id: str = None,
    connection_type: str = None,
    content_handling_strategy: str = None,
    credentials_arn: str = None,
    description: str = None,
    integration_method: str = None,
    integration_subtype: str = None,
    integration_type: str = None,
    integration_uri: str = None,
    passthrough_behavior: str = None,
    payload_format_version: str = None,
    request_parameters: Dict = None,
    request_templates: Dict = None,
    response_parameters: Dict = None,
    template_selection_expression: str = None,
    timeout_in_millis: int = None,
    tls_config: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates an Integration.

    Args:
        api_id(str): The API identifier.
        connection_id(str, optional): The ID of the VPC link for a private integration. Supported only for HTTP APIs. Defaults to None.
        connection_type(str, optional): The type of the network connection to the integration endpoint. Specify INTERNET for connections through the public routable internet or VPC_LINK for private connections between API Gateway and resources in a VPC. The default value is INTERNET. Defaults to None.
        content_handling_strategy(str, optional): Supported only for WebSocket APIs. Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors: CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob. CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string. If this property is not defined, the response payload will be passed through from the integration response to the route response or method response without modification. Defaults to None.
        credentials_arn(str, optional): Specifies the credentials required for the integration, if any. For AWS integrations, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify the string arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, specify null. Defaults to None.
        description(str, optional): The description of the integration. Defaults to None.
        integration_id(str): The integration ID.
        integration_method(str, optional): Specifies the integration's HTTP method type. Defaults to None.
        integration_subtype(str, optional): Supported only for HTTP API AWS_PROXY integrations. Specifies the AWS service action to invoke. To learn more, see Integration subtype reference. Defaults to None.
        integration_type(str, optional): The integration type of an integration. One of the following: AWS: for integrating the route or method request with an AWS service action, including the Lambda function-invoking action. With the Lambda function-invoking action, this is referred to as the Lambda custom integration. With any other AWS service action, this is known as AWS integration. Supported only for WebSocket APIs. AWS_PROXY: for integrating the route or method request with a Lambda function or other AWS service action. This integration is also referred to as a Lambda proxy integration. HTTP: for integrating the route or method request with an HTTP endpoint. This integration is also referred to as the HTTP custom integration. Supported only for WebSocket APIs. HTTP_PROXY: for integrating the route or method request with an HTTP endpoint, with the client request passed through as-is. This is also referred to as HTTP proxy integration. For HTTP API private integrations, use an HTTP_PROXY integration. MOCK: for integrating the route or method request with API Gateway as a "loopback" endpoint without invoking any backend. Supported only for WebSocket APIs. Defaults to None.
        integration_uri(str, optional): For a Lambda integration, specify the URI of a Lambda function. For an HTTP integration, specify a fully-qualified URL. For an HTTP API private integration, specify the ARN of an Application Load Balancer listener, Network Load Balancer listener, or AWS Cloud Map service. If you specify the ARN of an AWS Cloud Map service, API Gateway uses DiscoverInstances to identify resources. You can use query parameters to target specific resources. To learn more, see DiscoverInstances. For private integrations, all resources must be owned by the same AWS account. Defaults to None.
        passthrough_behavior(str, optional): Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource. There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER. Supported only for WebSocket APIs. WHEN_NO_MATCH passes the request body for unmapped content types through to the integration backend without transformation. NEVER rejects unmapped content types with an HTTP 415 Unsupported Media Type response. WHEN_NO_TEMPLATES allows pass-through when the integration has no content types mapped to templates. However, if there is at least one content type defined, unmapped content types will be rejected with the same HTTP 415 Unsupported Media Type response. Defaults to None.
        payload_format_version(str, optional): Specifies the format of the payload sent to an integration. Required for HTTP APIs. Defaults to None.
        request_parameters(Dict, optional): For WebSocket APIs, a key-value map specifying request parameters that are passed from the method request to the backend. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the backend. The method request parameter value must match the pattern of method.request.{location}.{name}
          , where
            {location}
           is querystring, path, or header; and
            {name}
           must be a valid and unique method request parameter name. For HTTP API integrations with a specified integrationSubtype, request parameters are a key-value map specifying parameters that are passed to AWS_PROXY integrations. You can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see Working with AWS service integrations for HTTP APIs. For HTTP API integrations, without a specified integrationSubtype request parameters are a key-value map specifying how to transform HTTP requests before sending them to the backend. The key should follow the pattern <action>:<header|querystring|path>.<location> where action can be append, overwrite or remove. For values, you can provide static values, or map request data, stage variables, or context variables that are evaluated at runtime. To learn more, see Transforming API requests and responses. Defaults to None.
        request_templates(Dict, optional): Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value. Supported only for WebSocket APIs. Defaults to None.
        response_parameters(Dict, optional): Supported only for HTTP APIs. You use response parameters to transform the HTTP response from a backend integration before returning the response to clients. Specify a key-value map from a selection key to response parameters. The selection key must be a valid HTTP status code within the range of 200-599. Response parameters are a key-value map. The key must match pattern <action>:<header>.<location> or overwrite.statuscode. The action can be append, overwrite or remove. The value can be a static value, or map to response data, stage variables, or context variables that are evaluated at runtime. To learn more, see Transforming API requests and responses. Defaults to None.
        template_selection_expression(str, optional): The template selection expression for the integration. Defaults to None.
        timeout_in_millis(int, optional): Custom timeout between 50 and 29,000 milliseconds for WebSocket APIs and between 50 and 30,000 milliseconds for HTTP APIs. The default timeout is 29 seconds for WebSocket APIs and 30 seconds for HTTP APIs. Defaults to None.
        tls_config(Dict, optional): The TLS configuration for a private integration. If you specify a TLS configuration, private integration traffic uses the HTTPS protocol. Supported only for HTTP APIs. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.integration.init.update(
                ctx, api_id=value, integration_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.integration.init.update api_id=value, integration_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="update_integration",
        op_kwargs={
            "ApiId": api_id,
            "ConnectionId": connection_id,
            "ConnectionType": connection_type,
            "ContentHandlingStrategy": content_handling_strategy,
            "CredentialsArn": credentials_arn,
            "Description": description,
            "IntegrationId": integration_id,
            "IntegrationMethod": integration_method,
            "IntegrationSubtype": integration_subtype,
            "IntegrationType": integration_type,
            "IntegrationUri": integration_uri,
            "PassthroughBehavior": passthrough_behavior,
            "PayloadFormatVersion": payload_format_version,
            "RequestParameters": request_parameters,
            "RequestTemplates": request_templates,
            "ResponseParameters": response_parameters,
            "TemplateSelectionExpression": template_selection_expression,
            "TimeoutInMillis": timeout_in_millis,
            "TlsConfig": tls_config,
        },
    )
