"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    domain_name: str,
    domain_name_configurations: List = None,
    mutual_tls_authentication: Dict = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a domain name.

    Args:
        domain_name(str): The domain name.
        domain_name_configurations(List, optional): The domain name configurations. Defaults to None.
        mutual_tls_authentication(Dict, optional): The mutual TLS authentication configuration for a custom domain name. Defaults to None.
        tags(Dict, optional): The collection of tags associated with a domain name. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.domain_name.create(ctx, domain_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.domain_name.create domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="create_domain_name",
        op_kwargs={
            "DomainName": domain_name,
            "DomainNameConfigurations": domain_name_configurations,
            "MutualTlsAuthentication": mutual_tls_authentication,
            "Tags": tags,
        },
    )


async def delete(hub, ctx, domain_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a domain name.

    Args:
        domain_name(str): The domain name.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.domain_name.delete(ctx, domain_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.domain_name.delete domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="delete_domain_name",
        op_kwargs={"DomainName": domain_name},
    )


async def get(hub, ctx, domain_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets a domain name.

    Args:
        domain_name(str): The domain name.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.domain_name.get(ctx, domain_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.domain_name.get domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="get_domain_name",
        op_kwargs={"DomainName": domain_name},
    )


async def get_all(hub, ctx, max_results: str = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Gets the domain names for an AWS account.

    Args:
        max_results(str, optional): The maximum number of elements to be returned for this resource. Defaults to None.
        next_token(str, optional): The next page of elements from this collection. Not valid for the last element of the collection. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.domain_name.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.domain_name.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="get_domain_names",
        op_kwargs={"MaxResults": max_results, "NextToken": next_token},
    )


async def update(
    hub,
    ctx,
    domain_name: str,
    domain_name_configurations: List = None,
    mutual_tls_authentication: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a domain name.

    Args:
        domain_name(str): The domain name.
        domain_name_configurations(List, optional): The domain name configurations. Defaults to None.
        mutual_tls_authentication(Dict, optional): The mutual TLS authentication configuration for a custom domain name. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.domain_name.update(ctx, domain_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.domain_name.update domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="update_domain_name",
        op_kwargs={
            "DomainName": domain_name,
            "DomainNameConfigurations": domain_name_configurations,
            "MutualTlsAuthentication": mutual_tls_authentication,
        },
    )
