"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub, ctx, api_id: str, description: str = None, stage_name: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a Deployment for an API.

    Args:
        api_id(str): The API identifier.
        description(str, optional): The description for the deployment resource. Defaults to None.
        stage_name(str, optional): The name of the Stage resource for the Deployment resource to create. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.deployment.create(ctx, api_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.deployment.create api_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="create_deployment",
        op_kwargs={
            "ApiId": api_id,
            "Description": description,
            "StageName": stage_name,
        },
    )


async def delete(hub, ctx, api_id: str, deployment_id: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a Deployment.

    Args:
        api_id(str): The API identifier.
        deployment_id(str): The deployment ID.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.deployment.delete(
                ctx, api_id=value, deployment_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.deployment.delete api_id=value, deployment_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="delete_deployment",
        op_kwargs={"ApiId": api_id, "DeploymentId": deployment_id},
    )


async def get(hub, ctx, api_id: str, deployment_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets a Deployment.

    Args:
        api_id(str): The API identifier.
        deployment_id(str): The deployment ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.deployment.get(
                ctx, api_id=value, deployment_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.deployment.get api_id=value, deployment_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="get_deployment",
        op_kwargs={"ApiId": api_id, "DeploymentId": deployment_id},
    )


async def get_all(
    hub, ctx, api_id: str, max_results: str = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Gets the Deployments for an API.

    Args:
        api_id(str): The API identifier.
        max_results(str, optional): The maximum number of elements to be returned for this resource. Defaults to None.
        next_token(str, optional): The next page of elements from this collection. Not valid for the last element of the collection. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.deployment.get_all(ctx, api_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.deployment.get_all api_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="get_deployments",
        op_kwargs={"ApiId": api_id, "MaxResults": max_results, "NextToken": next_token},
    )


async def update(
    hub, ctx, api_id: str, deployment_id: str, description: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a Deployment.

    Args:
        api_id(str): The API identifier.
        deployment_id(str): The deployment ID.
        description(str, optional): The description for the deployment resource. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.deployment.update(
                ctx, api_id=value, deployment_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.deployment.update api_id=value, deployment_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="update_deployment",
        op_kwargs={
            "ApiId": api_id,
            "DeploymentId": deployment_id,
            "Description": description,
        },
    )
