"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def delete(hub, ctx, api_id: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a CORS configuration.

    Args:
        api_id(str): The API identifier.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.cors_configuration.delete(ctx, api_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.cors_configuration.delete api_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="delete_cors_configuration",
        op_kwargs={"ApiId": api_id},
    )
