"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    api_id: str,
    authorizer_type: str,
    identity_source: List,
    name: str,
    authorizer_credentials_arn: str = None,
    authorizer_payload_format_version: str = None,
    authorizer_result_ttl_in_seconds: int = None,
    authorizer_uri: str = None,
    enable_simple_responses: bool = None,
    identity_validation_expression: str = None,
    jwt_configuration: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an Authorizer for an API.

    Args:
        api_id(str): The API identifier.
        authorizer_credentials_arn(str, optional): Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, don't specify this parameter. Supported only for REQUEST authorizers. Defaults to None.
        authorizer_payload_format_version(str, optional): Specifies the format of the payload sent to an HTTP API Lambda authorizer. Required for HTTP API Lambda authorizers. Supported values are 1.0 and 2.0. To learn more, see Working with AWS Lambda authorizers for HTTP APIs. Defaults to None.
        authorizer_result_ttl_in_seconds(int, optional): The time to live (TTL) for cached authorizer results, in seconds. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway caches authorizer responses. The maximum value is 3600, or 1 hour. Supported only for HTTP API Lambda authorizers. Defaults to None.
        authorizer_type(str): The authorizer type. Specify REQUEST for a Lambda function using incoming request parameters. Specify JWT to use JSON Web Tokens (supported only for HTTP APIs).
        authorizer_uri(str, optional): The authorizer's Uniform Resource Identifier (URI). For REQUEST authorizers, this must be a well-formed Lambda function URI, for example, arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:{account_id}:function:{lambda_function_name}/invocations. In general, the URI has this form: arn:aws:apigateway:{region}:lambda:path/{service_api}
               , where {region} is the same as the region hosting the Lambda function, path indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial /. For Lambda functions, this is usually of the form /2015-03-31/functions/[FunctionARN]/invocations. Supported only for REQUEST authorizers. Defaults to None.
        enable_simple_responses(bool, optional): Specifies whether a Lambda authorizer returns a response in a simple format. By default, a Lambda authorizer must return an IAM policy. If enabled, the Lambda authorizer can return a boolean value instead of an IAM policy. Supported only for HTTP APIs. To learn more, see Working with AWS Lambda authorizers for HTTP APIs. Defaults to None.
        identity_source(List): The identity source for which authorization is requested. For a REQUEST authorizer, this is optional. The value is a set of one or more mapping expressions of the specified request parameters. The identity source can be headers, query string parameters, stage variables, and context parameters. For example, if an Auth header and a Name query string parameter are defined as identity sources, this value is route.request.header.Auth, route.request.querystring.Name for WebSocket APIs. For HTTP APIs, use selection expressions prefixed with $, for example, $request.header.Auth, $request.querystring.Name. These parameters are used to perform runtime validation for Lambda-based authorizers by verifying all of the identity-related request parameters are present in the request, not null, and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function. Otherwise, it returns a 401 Unauthorized response without calling the Lambda function. For HTTP APIs, identity sources are also used as the cache key when caching is enabled. To learn more, see Working with AWS Lambda authorizers for HTTP APIs. For JWT, a single entry that specifies where to extract the JSON Web Token (JWT) from inbound requests. Currently only header-based and query parameter-based selections are supported, for example $request.header.Authorization.
        identity_validation_expression(str, optional): This parameter is not used. Defaults to None.
        jwt_configuration(Dict, optional): Represents the configuration of a JWT authorizer. Required for the JWT authorizer type. Supported only for HTTP APIs. Defaults to None.
        name(str): The name of the authorizer.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.authorizer.init.create(
                ctx, api_id=value, authorizer_type=value, identity_source=value, name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.authorizer.init.create api_id=value, authorizer_type=value, identity_source=value, name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="create_authorizer",
        op_kwargs={
            "ApiId": api_id,
            "AuthorizerCredentialsArn": authorizer_credentials_arn,
            "AuthorizerPayloadFormatVersion": authorizer_payload_format_version,
            "AuthorizerResultTtlInSeconds": authorizer_result_ttl_in_seconds,
            "AuthorizerType": authorizer_type,
            "AuthorizerUri": authorizer_uri,
            "EnableSimpleResponses": enable_simple_responses,
            "IdentitySource": identity_source,
            "IdentityValidationExpression": identity_validation_expression,
            "JwtConfiguration": jwt_configuration,
            "Name": name,
        },
    )


async def delete(hub, ctx, api_id: str, authorizer_id: str) -> None:
    r"""
    **Autogenerated function**

    Deletes an Authorizer.

    Args:
        api_id(str): The API identifier.
        authorizer_id(str): The authorizer identifier.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.authorizer.init.delete(
                ctx, api_id=value, authorizer_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.authorizer.init.delete api_id=value, authorizer_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="delete_authorizer",
        op_kwargs={"ApiId": api_id, "AuthorizerId": authorizer_id},
    )


async def get(hub, ctx, api_id: str, authorizer_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets an Authorizer.

    Args:
        api_id(str): The API identifier.
        authorizer_id(str): The authorizer identifier.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.authorizer.init.get(
                ctx, api_id=value, authorizer_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.authorizer.init.get api_id=value, authorizer_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="get_authorizer",
        op_kwargs={"ApiId": api_id, "AuthorizerId": authorizer_id},
    )


async def get_all(
    hub, ctx, api_id: str, max_results: str = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Gets the Authorizers for an API.

    Args:
        api_id(str): The API identifier.
        max_results(str, optional): The maximum number of elements to be returned for this resource. Defaults to None.
        next_token(str, optional): The next page of elements from this collection. Not valid for the last element of the collection. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.authorizer.init.get_all(ctx, api_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.authorizer.init.get_all api_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="get_authorizers",
        op_kwargs={"ApiId": api_id, "MaxResults": max_results, "NextToken": next_token},
    )


async def update(
    hub,
    ctx,
    api_id: str,
    authorizer_id: str,
    authorizer_credentials_arn: str = None,
    authorizer_payload_format_version: str = None,
    authorizer_result_ttl_in_seconds: int = None,
    authorizer_type: str = None,
    authorizer_uri: str = None,
    enable_simple_responses: bool = None,
    identity_source: List = None,
    identity_validation_expression: str = None,
    jwt_configuration: Dict = None,
    name: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates an Authorizer.

    Args:
        api_id(str): The API identifier.
        authorizer_credentials_arn(str, optional): Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, don't specify this parameter. Defaults to None.
        authorizer_id(str): The authorizer identifier.
        authorizer_payload_format_version(str, optional): Specifies the format of the payload sent to an HTTP API Lambda authorizer. Required for HTTP API Lambda authorizers. Supported values are 1.0 and 2.0. To learn more, see Working with AWS Lambda authorizers for HTTP APIs. Defaults to None.
        authorizer_result_ttl_in_seconds(int, optional): The time to live (TTL) for cached authorizer results, in seconds. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway caches authorizer responses. The maximum value is 3600, or 1 hour. Supported only for HTTP API Lambda authorizers. Defaults to None.
        authorizer_type(str, optional): The authorizer type. Specify REQUEST for a Lambda function using incoming request parameters. Specify JWT to use JSON Web Tokens (supported only for HTTP APIs). Defaults to None.
        authorizer_uri(str, optional): The authorizer's Uniform Resource Identifier (URI). For REQUEST authorizers, this must be a well-formed Lambda function URI, for example, arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:{account_id}:function:{lambda_function_name}/invocations. In general, the URI has this form: arn:aws:apigateway:{region}:lambda:path/{service_api}
               , where {region} is the same as the region hosting the Lambda function, path indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial /. For Lambda functions, this is usually of the form /2015-03-31/functions/[FunctionARN]/invocations. Supported only for REQUEST authorizers. Defaults to None.
        enable_simple_responses(bool, optional): Specifies whether a Lambda authorizer returns a response in a simple format. By default, a Lambda authorizer must return an IAM policy. If enabled, the Lambda authorizer can return a boolean value instead of an IAM policy. Supported only for HTTP APIs. To learn more, see Working with AWS Lambda authorizers for HTTP APIs. Defaults to None.
        identity_source(List, optional): The identity source for which authorization is requested. For a REQUEST authorizer, this is optional. The value is a set of one or more mapping expressions of the specified request parameters. The identity source can be headers, query string parameters, stage variables, and context parameters. For example, if an Auth header and a Name query string parameter are defined as identity sources, this value is route.request.header.Auth, route.request.querystring.Name for WebSocket APIs. For HTTP APIs, use selection expressions prefixed with $, for example, $request.header.Auth, $request.querystring.Name. These parameters are used to perform runtime validation for Lambda-based authorizers by verifying all of the identity-related request parameters are present in the request, not null, and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function. Otherwise, it returns a 401 Unauthorized response without calling the Lambda function. For HTTP APIs, identity sources are also used as the cache key when caching is enabled. To learn more, see Working with AWS Lambda authorizers for HTTP APIs. For JWT, a single entry that specifies where to extract the JSON Web Token (JWT) from inbound requests. Currently only header-based and query parameter-based selections are supported, for example $request.header.Authorization. Defaults to None.
        identity_validation_expression(str, optional): This parameter is not used. Defaults to None.
        jwt_configuration(Dict, optional): Represents the configuration of a JWT authorizer. Required for the JWT authorizer type. Supported only for HTTP APIs. Defaults to None.
        name(str, optional): The name of the authorizer. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.authorizer.init.update(
                ctx, api_id=value, authorizer_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.authorizer.init.update api_id=value, authorizer_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="update_authorizer",
        op_kwargs={
            "ApiId": api_id,
            "AuthorizerCredentialsArn": authorizer_credentials_arn,
            "AuthorizerId": authorizer_id,
            "AuthorizerPayloadFormatVersion": authorizer_payload_format_version,
            "AuthorizerResultTtlInSeconds": authorizer_result_ttl_in_seconds,
            "AuthorizerType": authorizer_type,
            "AuthorizerUri": authorizer_uri,
            "EnableSimpleResponses": enable_simple_responses,
            "IdentitySource": identity_source,
            "IdentityValidationExpression": identity_validation_expression,
            "JwtConfiguration": jwt_configuration,
            "Name": name,
        },
    )
