"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def reset(hub, ctx, api_id: str, stage_name: str) -> None:
    r"""
    **Autogenerated function**

    Resets all authorizer cache entries on a stage. Supported only for HTTP APIs.

    Args:
        api_id(str): The API identifier.
        stage_name(str): The stage name. Stage names can contain only alphanumeric characters, hyphens, and underscores, or be $default. Maximum length is 128 characters.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.authorizer.cache.reset(
                ctx, api_id=value, stage_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.authorizer.cache.reset api_id=value, stage_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="reset_authorizers_cache",
        op_kwargs={"ApiId": api_id, "StageName": stage_name},
    )
