"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, max_results: str = None, next_token: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Gets a collection of Api resources.

    Args:
        max_results(str, optional): The maximum number of elements to be returned for this resource. Defaults to None.
        next_token(str, optional): The next page of elements from this collection. Not valid for the last element of the collection. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.apis.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.apis.get
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="get_apis",
        op_kwargs={"MaxResults": max_results, "NextToken": next_token},
    )
