"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(
    hub, ctx, api_id: str, domain_name: str, stage: str, api_mapping_key: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an API mapping.

    Args:
        api_id(str): The API identifier.
        api_mapping_key(str, optional): The API mapping key. Defaults to None.
        domain_name(str): The domain name.
        stage(str): The API stage.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.api.mapping.create(
                ctx, api_id=value, domain_name=value, stage=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.api.mapping.create api_id=value, domain_name=value, stage=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="create_api_mapping",
        op_kwargs={
            "ApiId": api_id,
            "ApiMappingKey": api_mapping_key,
            "DomainName": domain_name,
            "Stage": stage,
        },
    )


async def delete(hub, ctx, api_mapping_id: str, domain_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes an API mapping.

    Args:
        api_mapping_id(str): The API mapping identifier.
        domain_name(str): The domain name.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.api.mapping.delete(
                ctx, api_mapping_id=value, domain_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.api.mapping.delete api_mapping_id=value, domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="delete_api_mapping",
        op_kwargs={"ApiMappingId": api_mapping_id, "DomainName": domain_name},
    )


async def get(hub, ctx, api_mapping_id: str, domain_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets an API mapping.

    Args:
        api_mapping_id(str): The API mapping identifier.
        domain_name(str): The domain name.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.api.mapping.get(
                ctx, api_mapping_id=value, domain_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.api.mapping.get api_mapping_id=value, domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="get_api_mapping",
        op_kwargs={"ApiMappingId": api_mapping_id, "DomainName": domain_name},
    )


async def get_all(
    hub, ctx, domain_name: str, max_results: str = None, next_token: str = None
) -> Dict:
    r"""
    **Autogenerated function**

    Gets API mappings.

    Args:
        domain_name(str): The domain name.
        max_results(str, optional): The maximum number of elements to be returned for this resource. Defaults to None.
        next_token(str, optional): The next page of elements from this collection. Not valid for the last element of the collection. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.api.mapping.get_all(ctx, domain_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.api.mapping.get_all domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="get_api_mappings",
        op_kwargs={
            "DomainName": domain_name,
            "MaxResults": max_results,
            "NextToken": next_token,
        },
    )


async def update(
    hub,
    ctx,
    api_id: str,
    api_mapping_id: str,
    domain_name: str,
    api_mapping_key: str = None,
    stage: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    The API mapping.

    Args:
        api_id(str): The API identifier.
        api_mapping_id(str): The API mapping identifier.
        api_mapping_key(str, optional): The API mapping key. Defaults to None.
        domain_name(str): The domain name.
        stage(str, optional): The API stage. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.api.mapping.update(
                ctx, api_id=value, api_mapping_id=value, domain_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.api.mapping.update api_id=value, api_mapping_id=value, domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="update_api_mapping",
        op_kwargs={
            "ApiId": api_id,
            "ApiMappingId": api_mapping_id,
            "ApiMappingKey": api_mapping_key,
            "DomainName": domain_name,
            "Stage": stage,
        },
    )
