"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"import_": "import"}


async def create(
    hub,
    ctx,
    name: str,
    protocol_type: str,
    api_key_selection_expression: str = None,
    cors_configuration: Dict = None,
    credentials_arn: str = None,
    description: str = None,
    disable_schema_validation: bool = None,
    disable_execute_api_endpoint: bool = None,
    route_key: str = None,
    route_selection_expression: str = None,
    tags: Dict = None,
    target: str = None,
    version: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates an Api resource.

    Args:
        api_key_selection_expression(str, optional): An API key selection expression. Supported only for WebSocket APIs. See API Key Selection Expressions. Defaults to None.
        cors_configuration(Dict, optional): A CORS configuration. Supported only for HTTP APIs. See Configuring CORS for more information. Defaults to None.
        credentials_arn(str, optional): This property is part of quick create. It specifies the credentials required for the integration, if any. For a Lambda integration, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, specify null. Currently, this property is not used for HTTP integrations. Supported only for HTTP APIs. Defaults to None.
        description(str, optional): The description of the API. Defaults to None.
        disable_schema_validation(bool, optional): Avoid validating models when creating a deployment. Supported only for WebSocket APIs. Defaults to None.
        disable_execute_api_endpoint(bool, optional): Specifies whether clients can invoke your API by using the default execute-api endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint. Defaults to None.
        name(str): The name of the API.
        protocol_type(str): The API protocol.
        route_key(str, optional): This property is part of quick create. If you don't specify a routeKey, a default route of $default is created. The $default route acts as a catch-all for any request made to your API, for a particular stage. The $default route key can't be modified. You can add routes after creating the API, and you can update the route keys of additional routes. Supported only for HTTP APIs. Defaults to None.
        route_selection_expression(str, optional): The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This property is required for WebSocket APIs. Defaults to None.
        tags(Dict, optional): The collection of tags. Each tag element is associated with a given resource. Defaults to None.
        target(str, optional): This property is part of quick create. Quick create produces an API with an integration, a default catch-all route, and a default stage which is configured to automatically deploy changes. For HTTP integrations, specify a fully qualified URL. For Lambda integrations, specify a function ARN. The type of the integration will be HTTP_PROXY or AWS_PROXY, respectively. Supported only for HTTP APIs. Defaults to None.
        version(str, optional): A version identifier for the API. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.api.init.create(ctx, name=value, protocol_type=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.api.init.create name=value, protocol_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="create_api",
        op_kwargs={
            "ApiKeySelectionExpression": api_key_selection_expression,
            "CorsConfiguration": cors_configuration,
            "CredentialsArn": credentials_arn,
            "Description": description,
            "DisableSchemaValidation": disable_schema_validation,
            "DisableExecuteApiEndpoint": disable_execute_api_endpoint,
            "Name": name,
            "ProtocolType": protocol_type,
            "RouteKey": route_key,
            "RouteSelectionExpression": route_selection_expression,
            "Tags": tags,
            "Target": target,
            "Version": version,
        },
    )


async def delete(hub, ctx, api_id: str) -> None:
    r"""
    **Autogenerated function**

    Deletes an Api resource.

    Args:
        api_id(str): The API identifier.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.api.init.delete(ctx, api_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.api.init.delete api_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="delete_api",
        op_kwargs={"ApiId": api_id},
    )


async def export(
    hub,
    ctx,
    api_id: str,
    output_type: str,
    specification: str,
    export_version: str = None,
    include_extensions: bool = None,
    stage_name: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Args:
        api_id(str): The API identifier.
        export_version(str, optional): The version of the API Gateway export algorithm. API Gateway uses the latest version by default. Currently, the only supported version is 1.0. Defaults to None.
        include_extensions(bool, optional): Specifies whether to include API Gateway extensions in the exported API definition. API Gateway extensions are included by default. Defaults to None.
        output_type(str): The output type of the exported definition file. Valid values are JSON and YAML.
        specification(str): The version of the API specification to use. OAS30, for OpenAPI 3.0, is the only supported value.
        stage_name(str, optional): The name of the API stage to export. If you don't specify this property, a representation of the latest API configuration is exported. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.api.init.export(ctx, api_id=value, output_type=value, specification=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.api.init.export api_id=value, output_type=value, specification=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="export_api",
        op_kwargs={
            "ApiId": api_id,
            "ExportVersion": export_version,
            "IncludeExtensions": include_extensions,
            "OutputType": output_type,
            "Specification": specification,
            "StageName": stage_name,
        },
    )


async def get(hub, ctx, api_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets an Api resource.

    Args:
        api_id(str): The API identifier.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.api.init.get(ctx, api_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.api.init.get api_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="get_api",
        op_kwargs={"ApiId": api_id},
    )


async def import_(
    hub, ctx, body: str, basepath: str = None, fail_on_warnings: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Imports an API.

    Args:
        basepath(str, optional): Specifies how to interpret the base path of the API during import. Valid values are ignore, prepend, and split. The default value is ignore. To learn more, see Set the OpenAPI basePath Property. Supported only for HTTP APIs. Defaults to None.
        body(str): The OpenAPI definition. Supported only for HTTP APIs.
        fail_on_warnings(bool, optional): Specifies whether to rollback the API creation when a warning is encountered. By default, API creation continues if a warning is encountered. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.api.init.import(ctx, body=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.api.init.import body=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="import_api",
        op_kwargs={
            "Basepath": basepath,
            "Body": body,
            "FailOnWarnings": fail_on_warnings,
        },
    )


async def reimport(
    hub,
    ctx,
    api_id: str,
    body: str,
    basepath: str = None,
    fail_on_warnings: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Puts an Api resource.

    Args:
        api_id(str): The API identifier.
        basepath(str, optional): Specifies how to interpret the base path of the API during import. Valid values are ignore, prepend, and split. The default value is ignore. To learn more, see Set the OpenAPI basePath Property. Supported only for HTTP APIs. Defaults to None.
        body(str): The OpenAPI definition. Supported only for HTTP APIs.
        fail_on_warnings(bool, optional): Specifies whether to rollback the API creation when a warning is encountered. By default, API creation continues if a warning is encountered. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.api.init.reimport(ctx, api_id=value, body=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.api.init.reimport api_id=value, body=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="reimport_api",
        op_kwargs={
            "ApiId": api_id,
            "Basepath": basepath,
            "Body": body,
            "FailOnWarnings": fail_on_warnings,
        },
    )


async def update(
    hub,
    ctx,
    api_id: str,
    api_key_selection_expression: str = None,
    cors_configuration: Dict = None,
    credentials_arn: str = None,
    description: str = None,
    disable_schema_validation: bool = None,
    disable_execute_api_endpoint: bool = None,
    name: str = None,
    route_key: str = None,
    route_selection_expression: str = None,
    target: str = None,
    version: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates an Api resource.

    Args:
        api_id(str): The API identifier.
        api_key_selection_expression(str, optional): An API key selection expression. Supported only for WebSocket APIs. See API Key Selection Expressions. Defaults to None.
        cors_configuration(Dict, optional): A CORS configuration. Supported only for HTTP APIs. Defaults to None.
        credentials_arn(str, optional): This property is part of quick create. It specifies the credentials required for the integration, if any. For a Lambda integration, three options are available. To specify an IAM Role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To require that the caller's identity be passed through from the request, specify arn:aws:iam::*:user/*. To use resource-based permissions on supported AWS services, don't specify this parameter. Currently, this property is not used for HTTP integrations. If provided, this value replaces the credentials associated with the quick create integration. Supported only for HTTP APIs. Defaults to None.
        description(str, optional): The description of the API. Defaults to None.
        disable_schema_validation(bool, optional): Avoid validating models when creating a deployment. Supported only for WebSocket APIs. Defaults to None.
        disable_execute_api_endpoint(bool, optional): Specifies whether clients can invoke your API by using the default execute-api endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint. Defaults to None.
        name(str, optional): The name of the API. Defaults to None.
        route_key(str, optional): This property is part of quick create. If not specified, the route created using quick create is kept. Otherwise, this value replaces the route key of the quick create route. Additional routes may still be added after the API is updated. Supported only for HTTP APIs. Defaults to None.
        route_selection_expression(str, optional): The route selection expression for the API. For HTTP APIs, the routeSelectionExpression must be ${request.method} ${request.path}. If not provided, this will be the default for HTTP APIs. This property is required for WebSocket APIs. Defaults to None.
        target(str, optional): This property is part of quick create. For HTTP integrations, specify a fully qualified URL. For Lambda integrations, specify a function ARN. The type of the integration will be HTTP_PROXY or AWS_PROXY, respectively. The value provided updates the integration URI and integration type. You can update a quick-created target, but you can't remove it from an API. Supported only for HTTP APIs. Defaults to None.
        version(str, optional): A version identifier for the API. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.api.init.update(ctx, api_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.api.init.update api_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="update_api",
        op_kwargs={
            "ApiId": api_id,
            "ApiKeySelectionExpression": api_key_selection_expression,
            "CorsConfiguration": cors_configuration,
            "CredentialsArn": credentials_arn,
            "Description": description,
            "DisableSchemaValidation": disable_schema_validation,
            "DisableExecuteApiEndpoint": disable_execute_api_endpoint,
            "Name": name,
            "RouteKey": route_key,
            "RouteSelectionExpression": route_selection_expression,
            "Target": target,
            "Version": version,
        },
    )
