"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def delete_multiple(hub, ctx, api_id: str, stage_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the AccessLogSettings for a Stage. To disable access logging for a Stage, delete its AccessLogSettings.

    Args:
        api_id(str): The API identifier.
        stage_name(str): The stage name. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewayv2.access_log_setting.delete_multiple(
                ctx, api_id=value, stage_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewayv2.access_log_setting.delete_multiple api_id=value, stage_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewayv2",
        operation="delete_access_log_settings",
        op_kwargs={"ApiId": api_id, "StageName": stage_name},
    )
