"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def post(hub, ctx, data: bytes, connection_id: str) -> None:
    r"""
    **Autogenerated function**

    Sends the provided data to the specified connection.

    Args:
        data(bytes): The data to be sent to the client specified by its connection id.
        connection_id(str): The identifier of the connection that a specific client is using.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewaymanagementapi.to_connection.post(
                ctx, data=value, connection_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewaymanagementapi.to_connection.post data=value, connection_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewaymanagementapi",
        operation="post_to_connection",
        op_kwargs={"Data": data, "ConnectionId": connection_id},
    )
