"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def delete(hub, ctx, connection_id: str) -> None:
    r"""
    **Autogenerated function**

    Delete the connection with the provided id.

    Args:
        connection_id(str): .
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewaymanagementapi.connection.delete(
                ctx, connection_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewaymanagementapi.connection.delete connection_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewaymanagementapi",
        operation="delete_connection",
        op_kwargs={"ConnectionId": connection_id},
    )


async def get(hub, ctx, connection_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Get information about the connection with the provided id.

    Args:
        connection_id(str): .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigatewaymanagementapi.connection.get(ctx, connection_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigatewaymanagementapi.connection.get connection_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigatewaymanagementapi",
        operation="get_connection",
        op_kwargs={"ConnectionId": connection_id},
    )
