"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub, ctx, name: str, target_arns: List, description: str = None, tags: Dict = None
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a VPC link, under the caller's account in a selected region, in an asynchronous operation that typically takes 2-4 minutes to complete and become operational. The caller must have permissions to create and update VPC Endpoint services.

    Args:
        name(str): [Required] The name used to label and identify the VPC link.
        description(str, optional): The description of the VPC link. Defaults to None.
        target_arns(List): [Required] The ARN of the network load balancer of the VPC targeted by the VPC link. The network load balancer must be owned by the same AWS account of the API owner.
        tags(Dict, optional): The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with aws:. The tag value can be up to 256 characters. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.vpc_link.create(ctx, name=value, target_arns=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.vpc_link.create name=value, target_arns=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="create_vpc_link",
        op_kwargs={
            "name": name,
            "description": description,
            "targetArns": target_arns,
            "tags": tags,
        },
    )


async def delete(hub, ctx, vpc_link_id: str) -> None:
    r"""
    **Autogenerated function**

    Deletes an existing VpcLink of a specified identifier.

    Args:
        vpc_link_id(str): [Required] The identifier of the VpcLink. It is used in an Integration to reference this VpcLink.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.vpc_link.delete(ctx, vpc_link_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.vpc_link.delete vpc_link_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="delete_vpc_link",
        op_kwargs={"vpcLinkId": vpc_link_id},
    )


async def get(hub, ctx, vpc_link_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets a specified VPC link under the caller's account in a region.

    Args:
        vpc_link_id(str): [Required] The identifier of the VpcLink. It is used in an Integration to reference this VpcLink.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.vpc_link.get(ctx, vpc_link_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.vpc_link.get vpc_link_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="get_vpc_link",
        op_kwargs={"vpcLinkId": vpc_link_id},
    )


async def get_all(hub, ctx, position: str = None, limit: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Gets the VpcLinks collection under the caller's account in a selected region.

    Args:
        position(str, optional): The current pagination position in the paged result set. Defaults to None.
        limit(int, optional): The maximum number of returned results per page. The default value is 25 and the maximum value is 500. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.vpc_link.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.vpc_link.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="get_vpc_links",
        op_kwargs={"position": position, "limit": limit},
    )


async def update(hub, ctx, vpc_link_id: str, patch_operations: List = None) -> Dict:
    r"""
    **Autogenerated function**

    Updates an existing VpcLink of a specified identifier.

    Args:
        vpc_link_id(str): [Required] The identifier of the VpcLink. It is used in an Integration to reference this VpcLink.
        patch_operations(List, optional): A list of update operations to be applied to the specified resource and in the order specified in this list. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.vpc_link.update(ctx, vpc_link_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.vpc_link.update vpc_link_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="update_vpc_link",
        op_kwargs={"vpcLinkId": vpc_link_id, "patchOperations": patch_operations},
    )
