"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, usage_plan_id: str, key_id: str, key_type: str) -> Dict:
    r"""
    **Autogenerated function**

    Creates a usage plan key for adding an existing API key to a usage plan.

    Args:
        usage_plan_id(str): [Required] The Id of the UsagePlan resource representing the usage plan containing the to-be-created UsagePlanKey resource representing a plan customer.
        key_id(str): [Required] The identifier of a UsagePlanKey resource for a plan customer.
        key_type(str): [Required] The type of a UsagePlanKey resource for a plan customer.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.usage.plan.key.create(
                ctx, usage_plan_id=value, key_id=value, key_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.usage.plan.key.create usage_plan_id=value, key_id=value, key_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="create_usage_plan_key",
        op_kwargs={"usagePlanId": usage_plan_id, "keyId": key_id, "keyType": key_type},
    )


async def delete(hub, ctx, usage_plan_id: str, key_id: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a usage plan key and remove the underlying API key from the associated usage plan.

    Args:
        usage_plan_id(str): [Required] The Id of the UsagePlan resource representing the usage plan containing the to-be-deleted UsagePlanKey resource representing a plan customer.
        key_id(str): [Required] The Id of the UsagePlanKey resource to be deleted.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.usage.plan.key.delete(
                ctx, usage_plan_id=value, key_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.usage.plan.key.delete usage_plan_id=value, key_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="delete_usage_plan_key",
        op_kwargs={"usagePlanId": usage_plan_id, "keyId": key_id},
    )


async def get(hub, ctx, usage_plan_id: str, key_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets a usage plan key of a given key identifier.

    Args:
        usage_plan_id(str): [Required] The Id of the UsagePlan resource representing the usage plan containing the to-be-retrieved UsagePlanKey resource representing a plan customer.
        key_id(str): [Required] The key Id of the to-be-retrieved UsagePlanKey resource representing a plan customer.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.usage.plan.key.get(
                ctx, usage_plan_id=value, key_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.usage.plan.key.get usage_plan_id=value, key_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="get_usage_plan_key",
        op_kwargs={"usagePlanId": usage_plan_id, "keyId": key_id},
    )


async def get_all(
    hub,
    ctx,
    usage_plan_id: str,
    position: str = None,
    limit: int = None,
    name_query: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets all the usage plan keys representing the API keys added to a specified usage plan.

    Args:
        usage_plan_id(str): [Required] The Id of the UsagePlan resource representing the usage plan containing the to-be-retrieved UsagePlanKey resource representing a plan customer.
        position(str, optional): The current pagination position in the paged result set. Defaults to None.
        limit(int, optional): The maximum number of returned results per page. The default value is 25 and the maximum value is 500. Defaults to None.
        name_query(str, optional): A query parameter specifying the name of the to-be-returned usage plan keys. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.usage.plan.key.get_all(ctx, usage_plan_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.usage.plan.key.get_all usage_plan_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="get_usage_plan_keys",
        op_kwargs={
            "usagePlanId": usage_plan_id,
            "position": position,
            "limit": limit,
            "nameQuery": name_query,
        },
    )
