"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    name: str,
    description: str = None,
    api_stages: List = None,
    throttle: Dict = None,
    quota: Dict = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a usage plan with the throttle and quota limits, as well as the associated API stages, specified in the payload.

    Args:
        name(str): [Required] The name of the usage plan.
        description(str, optional): The description of the usage plan. Defaults to None.
        api_stages(List, optional): The associated API stages of the usage plan. Defaults to None.
        throttle(Dict, optional): The throttling limits of the usage plan. Defaults to None.
        quota(Dict, optional): The quota of the usage plan. Defaults to None.
        tags(Dict, optional): The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with aws:. The tag value can be up to 256 characters. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.usage.plan.init.create(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.usage.plan.init.create name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="create_usage_plan",
        op_kwargs={
            "name": name,
            "description": description,
            "apiStages": api_stages,
            "throttle": throttle,
            "quota": quota,
            "tags": tags,
        },
    )


async def delete(hub, ctx, usage_plan_id: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a usage plan of a given plan Id.

    Args:
        usage_plan_id(str): [Required] The Id of the to-be-deleted usage plan.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.usage.plan.init.delete(ctx, usage_plan_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.usage.plan.init.delete usage_plan_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="delete_usage_plan",
        op_kwargs={"usagePlanId": usage_plan_id},
    )


async def get(hub, ctx, usage_plan_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets a usage plan of a given plan identifier.

    Args:
        usage_plan_id(str): [Required] The identifier of the UsagePlan resource to be retrieved.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.usage.plan.init.get(ctx, usage_plan_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.usage.plan.init.get usage_plan_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="get_usage_plan",
        op_kwargs={"usagePlanId": usage_plan_id},
    )


async def get_all(
    hub, ctx, position: str = None, key_id: str = None, limit: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Gets all the usage plans of the caller's account.

    Args:
        position(str, optional): The current pagination position in the paged result set. Defaults to None.
        key_id(str, optional): The identifier of the API key associated with the usage plans. Defaults to None.
        limit(int, optional): The maximum number of returned results per page. The default value is 25 and the maximum value is 500. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.usage.plan.init.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.usage.plan.init.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="get_usage_plans",
        op_kwargs={"position": position, "keyId": key_id, "limit": limit},
    )


async def update(hub, ctx, usage_plan_id: str, patch_operations: List = None) -> Dict:
    r"""
    **Autogenerated function**

    Updates a usage plan of a given plan Id.

    Args:
        usage_plan_id(str): [Required] The Id of the to-be-updated usage plan.
        patch_operations(List, optional): A list of update operations to be applied to the specified resource and in the order specified in this list. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.usage.plan.init.update(ctx, usage_plan_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.usage.plan.init.update usage_plan_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="update_usage_plan",
        op_kwargs={"usagePlanId": usage_plan_id, "patchOperations": patch_operations},
    )
