"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get(
    hub,
    ctx,
    usage_plan_id: str,
    start_date: str,
    end_date: str,
    key_id: str = None,
    position: str = None,
    limit: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets the usage data of a usage plan in a specified time interval.

    Args:
        usage_plan_id(str): [Required] The Id of the usage plan associated with the usage data.
        key_id(str, optional): The Id of the API key associated with the resultant usage data. Defaults to None.
        start_date(str): [Required] The starting date (e.g., 2016-01-01) of the usage data.
        end_date(str): [Required] The ending date (e.g., 2016-12-31) of the usage data.
        position(str, optional): The current pagination position in the paged result set. Defaults to None.
        limit(int, optional): The maximum number of returned results per page. The default value is 25 and the maximum value is 500. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.usage.init.get(
                ctx, usage_plan_id=value, start_date=value, end_date=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.usage.init.get usage_plan_id=value, start_date=value, end_date=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="get_usage",
        op_kwargs={
            "usagePlanId": usage_plan_id,
            "keyId": key_id,
            "startDate": start_date,
            "endDate": end_date,
            "position": position,
            "limit": limit,
        },
    )


async def update(
    hub, ctx, usage_plan_id: str, key_id: str, patch_operations: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Grants a temporary extension to the remaining quota of a usage plan associated with a specified API key.

    Args:
        usage_plan_id(str): [Required] The Id of the usage plan associated with the usage data.
        key_id(str): [Required] The identifier of the API key associated with the usage plan in which a temporary extension is granted to the remaining quota.
        patch_operations(List, optional): A list of update operations to be applied to the specified resource and in the order specified in this list. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.usage.init.update(
                ctx, usage_plan_id=value, key_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.usage.init.update usage_plan_id=value, key_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="update_usage",
        op_kwargs={
            "usagePlanId": usage_plan_id,
            "keyId": key_id,
            "patchOperations": patch_operations,
        },
    )
