"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub, ctx, resource_arn: str, position: str = None, limit: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Gets the Tags collection for a given resource.

    Args:
        resource_arn(str): [Required] The ARN of a resource that can be tagged.
        position(str, optional): (Not currently supported) The current pagination position in the paged result set. Defaults to None.
        limit(int, optional): (Not currently supported) The maximum number of returned results per page. The default value is 25 and the maximum value is 500. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.tags.get(ctx, resource_arn=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.tags.get resource_arn=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="get_tags",
        op_kwargs={"resourceArn": resource_arn, "position": position, "limit": limit},
    )
