"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    rest_api_id: str,
    stage_name: str,
    deployment_id: str,
    description: str = None,
    cache_cluster_enabled: bool = None,
    cache_cluster_size: str = None,
    variables: Dict = None,
    documentation_version: str = None,
    canary_settings: Dict = None,
    tracing_enabled: bool = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new Stage resource that references a pre-existing Deployment for the API.

    Args:
        rest_api_id(str): [Required] The string identifier of the associated RestApi.
        stage_name(str): [Required] The name for the Stage resource. Stage names can only contain alphanumeric characters, hyphens, and underscores. Maximum length is 128 characters.
        deployment_id(str): [Required] The identifier of the Deployment resource for the Stage resource.
        description(str, optional): The description of the Stage resource. Defaults to None.
        cache_cluster_enabled(bool, optional): Whether cache clustering is enabled for the stage. Defaults to None.
        cache_cluster_size(str, optional): The stage's cache cluster size. Defaults to None.
        variables(Dict, optional): A map that defines the stage variables for the new Stage resource. Variable names can have alphanumeric and underscore characters, and the values must match [A-Za-z0-9-._~:/?#&=,]+. Defaults to None.
        documentation_version(str, optional): The version of the associated API documentation. Defaults to None.
        canary_settings(Dict, optional): The canary deployment settings of this stage. Defaults to None.
        tracing_enabled(bool, optional): Specifies whether active tracing with X-ray is enabled for the Stage. Defaults to None.
        tags(Dict, optional): The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with aws:. The tag value can be up to 256 characters. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.stage.init.create(
                ctx, rest_api_id=value, stage_name=value, deployment_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.stage.init.create rest_api_id=value, stage_name=value, deployment_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="create_stage",
        op_kwargs={
            "restApiId": rest_api_id,
            "stageName": stage_name,
            "deploymentId": deployment_id,
            "description": description,
            "cacheClusterEnabled": cache_cluster_enabled,
            "cacheClusterSize": cache_cluster_size,
            "variables": variables,
            "documentationVersion": documentation_version,
            "canarySettings": canary_settings,
            "tracingEnabled": tracing_enabled,
            "tags": tags,
        },
    )


async def delete(hub, ctx, rest_api_id: str, stage_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a Stage resource.

    Args:
        rest_api_id(str): [Required] The string identifier of the associated RestApi.
        stage_name(str): [Required] The name of the Stage resource to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.stage.init.delete(
                ctx, rest_api_id=value, stage_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.stage.init.delete rest_api_id=value, stage_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="delete_stage",
        op_kwargs={"restApiId": rest_api_id, "stageName": stage_name},
    )


async def get(hub, ctx, rest_api_id: str, stage_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about a Stage resource.

    Args:
        rest_api_id(str): [Required] The string identifier of the associated RestApi.
        stage_name(str): [Required] The name of the Stage resource to get information about.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.stage.init.get(
                ctx, rest_api_id=value, stage_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.stage.init.get rest_api_id=value, stage_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="get_stage",
        op_kwargs={"restApiId": rest_api_id, "stageName": stage_name},
    )


async def get_all(hub, ctx, rest_api_id: str, deployment_id: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about one or more Stage resources.

    Args:
        rest_api_id(str): [Required] The string identifier of the associated RestApi.
        deployment_id(str, optional): The stages' deployment identifiers. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.stage.init.get_all(ctx, rest_api_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.stage.init.get_all rest_api_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="get_stages",
        op_kwargs={"restApiId": rest_api_id, "deploymentId": deployment_id},
    )


async def update(
    hub, ctx, rest_api_id: str, stage_name: str, patch_operations: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Changes information about a Stage resource.

    Args:
        rest_api_id(str): [Required] The string identifier of the associated RestApi.
        stage_name(str): [Required] The name of the Stage resource to change information about.
        patch_operations(List, optional): A list of update operations to be applied to the specified resource and in the order specified in this list. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.stage.init.update(
                ctx, rest_api_id=value, stage_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.stage.init.update rest_api_id=value, stage_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="update_stage",
        op_kwargs={
            "restApiId": rest_api_id,
            "stageName": stage_name,
            "patchOperations": patch_operations,
        },
    )
