"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""


async def flush(hub, ctx, rest_api_id: str, stage_name: str) -> None:
    r"""
    **Autogenerated function**

    Flushes a stage's cache.

    Args:
        rest_api_id(str): [Required] The string identifier of the associated RestApi.
        stage_name(str): [Required] The name of the stage to flush its cache.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.stage.cache.flush(
                ctx, rest_api_id=value, stage_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.stage.cache.flush rest_api_id=value, stage_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="flush_stage_cache",
        op_kwargs={"restApiId": rest_api_id, "stageName": stage_name},
    )
