"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, position: str = None, limit: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists the RestApis resources for your collection.

    Args:
        position(str, optional): The current pagination position in the paged result set. Defaults to None.
        limit(int, optional): The maximum number of returned results per page. The default value is 25 and the maximum value is 500. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.rest_apis.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.rest_apis.get
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="get_rest_apis",
        op_kwargs={"position": position, "limit": limit},
    )
