"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__func_alias__ = {"import_": "import"}


async def create(
    hub,
    ctx,
    name: str,
    description: str = None,
    version: str = None,
    clone_from: str = None,
    binary_media_types: List = None,
    minimum_compression_size: int = None,
    api_key_source: str = None,
    endpoint_configuration: Dict = None,
    policy: str = None,
    tags: Dict = None,
    disable_execute_api_endpoint: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new RestApi resource.

    Args:
        name(str): [Required] The name of the RestApi.
        description(str, optional): The description of the RestApi. Defaults to None.
        version(str, optional): A version identifier for the API. Defaults to None.
        clone_from(str, optional): The ID of the RestApi that you want to clone from. Defaults to None.
        binary_media_types(List, optional): The list of binary media types supported by the RestApi. By default, the RestApi supports only UTF-8-encoded text payloads. Defaults to None.
        minimum_compression_size(int, optional): A nullable integer that is used to enable compression (with non-negative between 0 and 10485760 (10M) bytes, inclusive) or disable compression (with a null value) on an API. When compression is enabled, compression or decompression is not applied on the payload if the payload size is smaller than this value. Setting it to zero allows compression for any payload size. Defaults to None.
        api_key_source(str, optional): The source of the API key for metering requests according to a usage plan. Valid values are: HEADER to read the API key from the X-API-Key header of a request. AUTHORIZER to read the API key from the UsageIdentifierKey from a custom authorizer. Defaults to None.
        endpoint_configuration(Dict, optional): The endpoint configuration of this RestApi showing the endpoint types of the API. Defaults to None.
        policy(str, optional): A stringified JSON policy document that applies to this RestApi regardless of the caller and Method configuration. Defaults to None.
        tags(Dict, optional): The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with aws:. The tag value can be up to 256 characters. Defaults to None.
        disable_execute_api_endpoint(bool, optional): Specifies whether clients can invoke your API by using the default execute-api endpoint. By default, clients can invoke your API with the default https://{api_id}.execute-api.{region}.amazonaws.com endpoint. To require that clients use a custom domain name to invoke your API, disable the default endpoint. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.rest_api.create(ctx, name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.rest_api.create name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="create_rest_api",
        op_kwargs={
            "name": name,
            "description": description,
            "version": version,
            "cloneFrom": clone_from,
            "binaryMediaTypes": binary_media_types,
            "minimumCompressionSize": minimum_compression_size,
            "apiKeySource": api_key_source,
            "endpointConfiguration": endpoint_configuration,
            "policy": policy,
            "tags": tags,
            "disableExecuteApiEndpoint": disable_execute_api_endpoint,
        },
    )


async def delete(hub, ctx, rest_api_id: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the specified API.

    Args:
        rest_api_id(str): [Required] The string identifier of the associated RestApi.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.rest_api.delete(ctx, rest_api_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.rest_api.delete rest_api_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="delete_rest_api",
        op_kwargs={"restApiId": rest_api_id},
    )


async def get(hub, ctx, rest_api_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Lists the RestApi resource in the collection.

    Args:
        rest_api_id(str): [Required] The string identifier of the associated RestApi.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.rest_api.get(ctx, rest_api_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.rest_api.get rest_api_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="get_rest_api",
        op_kwargs={"restApiId": rest_api_id},
    )


async def import_(
    hub, ctx, body: bytes, fail_on_warnings: bool = None, parameters: Dict = None
) -> Dict:
    r"""
    **Autogenerated function**

    A feature of the API Gateway control service for creating a new API from an external API definition file.

    Args:
        fail_on_warnings(bool, optional): A query parameter to indicate whether to rollback the API creation (true) or not (false) when a warning is encountered. The default value is false. Defaults to None.
        parameters(Dict, optional): A key-value map of context-specific query string parameters specifying the behavior of different API importing operations. The following shows operation-specific parameters and their supported values.  To exclude DocumentationParts from the import, set parameters as ignore=documentation.  To configure the endpoint type, set parameters as endpointConfigurationTypes=EDGE, endpointConfigurationTypes=REGIONAL, or endpointConfigurationTypes=PRIVATE. The default endpoint type is EDGE.  To handle imported basepath, set parameters as basepath=ignore, basepath=prepend or basepath=split. For example, the AWS CLI command to exclude documentation from the imported API is: aws apigateway import-rest-api --parameters ignore=documentation --body 'file:///path/to/imported-api-body.json' The AWS CLI command to set the regional endpoint on the imported API is: aws apigateway import-rest-api --parameters endpointConfigurationTypes=REGIONAL --body 'file:///path/to/imported-api-body.json'. Defaults to None.
        body(bytes): [Required] The POST request body containing external API definitions. Currently, only OpenAPI definition JSON/YAML files are supported. The maximum size of the API definition file is 6MB.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.rest_api.import(ctx, body=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.rest_api.import body=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="import_rest_api",
        op_kwargs={
            "failOnWarnings": fail_on_warnings,
            "parameters": parameters,
            "body": body,
        },
    )


async def put(
    hub,
    ctx,
    rest_api_id: str,
    body: bytes,
    mode: str = None,
    fail_on_warnings: bool = None,
    parameters: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    A feature of the API Gateway control service for updating an existing API with an input of external API definitions. The update can take the form of merging the supplied definition into the existing API or overwriting the existing API.

    Args:
        rest_api_id(str): [Required] The string identifier of the associated RestApi.
        mode(str, optional): The mode query parameter to specify the update mode. Valid values are "merge" and "overwrite". By default, the update mode is "merge". Defaults to None.
        fail_on_warnings(bool, optional): A query parameter to indicate whether to rollback the API update (true) or not (false) when a warning is encountered. The default value is false. Defaults to None.
        parameters(Dict, optional): Custom header parameters as part of the request. For example, to exclude DocumentationParts from an imported API, set ignore=documentation as a parameters value, as in the AWS CLI command of aws apigateway import-rest-api --parameters ignore=documentation --body 'file:///path/to/imported-api-body.json'. Defaults to None.
        body(bytes): [Required] The PUT request body containing external API definitions. Currently, only OpenAPI definition JSON/YAML files are supported. The maximum size of the API definition file is 6MB.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.rest_api.put(ctx, rest_api_id=value, body=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.rest_api.put rest_api_id=value, body=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="put_rest_api",
        op_kwargs={
            "restApiId": rest_api_id,
            "mode": mode,
            "failOnWarnings": fail_on_warnings,
            "parameters": parameters,
            "body": body,
        },
    )


async def update(hub, ctx, rest_api_id: str, patch_operations: List = None) -> Dict:
    r"""
    **Autogenerated function**

    Changes information about the specified API.

    Args:
        rest_api_id(str): [Required] The string identifier of the associated RestApi.
        patch_operations(List, optional): A list of update operations to be applied to the specified resource and in the order specified in this list. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.rest_api.update(ctx, rest_api_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.rest_api.update rest_api_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="update_rest_api",
        op_kwargs={"restApiId": rest_api_id, "patchOperations": patch_operations},
    )
