"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(hub, ctx, rest_api_id: str, parent_id: str, path_part: str) -> Dict:
    r"""
    **Autogenerated function**

    Creates a Resource resource.

    Args:
        rest_api_id(str): [Required] The string identifier of the associated RestApi.
        parent_id(str): [Required] The parent resource's identifier.
        path_part(str): The last path segment for this resource.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.resource.create(
                ctx, rest_api_id=value, parent_id=value, path_part=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.resource.create rest_api_id=value, parent_id=value, path_part=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="create_resource",
        op_kwargs={
            "restApiId": rest_api_id,
            "parentId": parent_id,
            "pathPart": path_part,
        },
    )


async def delete(hub, ctx, rest_api_id: str, resource_id: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a Resource resource.

    Args:
        rest_api_id(str): [Required] The string identifier of the associated RestApi.
        resource_id(str): [Required] The identifier of the Resource resource.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.resource.delete(
                ctx, rest_api_id=value, resource_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.resource.delete rest_api_id=value, resource_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="delete_resource",
        op_kwargs={"restApiId": rest_api_id, "resourceId": resource_id},
    )


async def get(hub, ctx, rest_api_id: str, resource_id: str, embed: List = None) -> Dict:
    r"""
    **Autogenerated function**

    Lists information about a resource.

    Args:
        rest_api_id(str): [Required] The string identifier of the associated RestApi.
        resource_id(str): [Required] The identifier for the Resource resource.
        embed(List, optional): A query parameter to retrieve the specified resources embedded in the returned Resource representation in the response. This embed parameter value is a list of comma-separated strings. Currently, the request supports only retrieval of the embedded Method resources this way. The query parameter value must be a single-valued list and contain the "methods" string. For example, GET /restapis/{restapi_id}/resources/{resource_id}?embed=methods. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.resource.get(
                ctx, rest_api_id=value, resource_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.resource.get rest_api_id=value, resource_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="get_resource",
        op_kwargs={"restApiId": rest_api_id, "resourceId": resource_id, "embed": embed},
    )


async def get_all(
    hub,
    ctx,
    rest_api_id: str,
    position: str = None,
    limit: int = None,
    embed: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists information about a collection of Resource resources.

    Args:
        rest_api_id(str): [Required] The string identifier of the associated RestApi.
        position(str, optional): The current pagination position in the paged result set. Defaults to None.
        limit(int, optional): The maximum number of returned results per page. The default value is 25 and the maximum value is 500. Defaults to None.
        embed(List, optional): A query parameter used to retrieve the specified resources embedded in the returned Resources resource in the response. This embed parameter value is a list of comma-separated strings. Currently, the request supports only retrieval of the embedded Method resources this way. The query parameter value must be a single-valued list and contain the "methods" string. For example, GET /restapis/{restapi_id}/resources?embed=methods. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.resource.get_all(ctx, rest_api_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.resource.get_all rest_api_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="get_resources",
        op_kwargs={
            "restApiId": rest_api_id,
            "position": position,
            "limit": limit,
            "embed": embed,
        },
    )


async def tag(hub, ctx, resource_arn: str, tags: Dict) -> None:
    r"""
    **Autogenerated function**

    Adds or updates a tag on a given resource.

    Args:
        resource_arn(str): [Required] The ARN of a resource that can be tagged.
        tags(Dict): [Required] The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with aws:. The tag value can be up to 256 characters.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.resource.tag(ctx, resource_arn=value, tags=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.resource.tag resource_arn=value, tags=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="tag_resource",
        op_kwargs={"resourceArn": resource_arn, "tags": tags},
    )


async def untag(hub, ctx, resource_arn: str, tag_keys: List) -> None:
    r"""
    **Autogenerated function**

    Removes a tag from a given resource.

    Args:
        resource_arn(str): [Required] The ARN of a resource that can be tagged.
        tag_keys(List): [Required] The Tag keys to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.resource.untag(
                ctx, resource_arn=value, tag_keys=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.resource.untag resource_arn=value, tag_keys=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="untag_resource",
        op_kwargs={"resourceArn": resource_arn, "tagKeys": tag_keys},
    )


async def update(
    hub, ctx, rest_api_id: str, resource_id: str, patch_operations: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Changes information about a Resource resource.

    Args:
        rest_api_id(str): [Required] The string identifier of the associated RestApi.
        resource_id(str): [Required] The identifier of the Resource resource.
        patch_operations(List, optional): A list of update operations to be applied to the specified resource and in the order specified in this list. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.resource.update(
                ctx, rest_api_id=value, resource_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.resource.update rest_api_id=value, resource_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="update_resource",
        op_kwargs={
            "restApiId": rest_api_id,
            "resourceId": resource_id,
            "patchOperations": patch_operations,
        },
    )
