"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    rest_api_id: str,
    name: str = None,
    validate_request_body: bool = None,
    validate_request_parameters: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a ReqeustValidator of a given RestApi.

    Args:
        rest_api_id(str): [Required] The string identifier of the associated RestApi.
        name(str, optional): The name of the to-be-created RequestValidator. Defaults to None.
        validate_request_body(bool, optional): A Boolean flag to indicate whether to validate request body according to the configured model schema for the method (true) or not (false). Defaults to None.
        validate_request_parameters(bool, optional): A Boolean flag to indicate whether to validate request parameters, true, or not false. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.request_validator.create(ctx, rest_api_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.request_validator.create rest_api_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="create_request_validator",
        op_kwargs={
            "restApiId": rest_api_id,
            "name": name,
            "validateRequestBody": validate_request_body,
            "validateRequestParameters": validate_request_parameters,
        },
    )


async def delete(hub, ctx, rest_api_id: str, request_validator_id: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a RequestValidator of a given RestApi.

    Args:
        rest_api_id(str): [Required] The string identifier of the associated RestApi.
        request_validator_id(str): [Required] The identifier of the RequestValidator to be deleted.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.request_validator.delete(
                ctx, rest_api_id=value, request_validator_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.request_validator.delete rest_api_id=value, request_validator_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="delete_request_validator",
        op_kwargs={
            "restApiId": rest_api_id,
            "requestValidatorId": request_validator_id,
        },
    )


async def get(hub, ctx, rest_api_id: str, request_validator_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets a RequestValidator of a given RestApi.

    Args:
        rest_api_id(str): [Required] The string identifier of the associated RestApi.
        request_validator_id(str): [Required] The identifier of the RequestValidator to be retrieved.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.request_validator.get(
                ctx, rest_api_id=value, request_validator_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.request_validator.get rest_api_id=value, request_validator_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="get_request_validator",
        op_kwargs={
            "restApiId": rest_api_id,
            "requestValidatorId": request_validator_id,
        },
    )


async def get_all(
    hub, ctx, rest_api_id: str, position: str = None, limit: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Gets the RequestValidators collection of a given RestApi.

    Args:
        rest_api_id(str): [Required] The string identifier of the associated RestApi.
        position(str, optional): The current pagination position in the paged result set. Defaults to None.
        limit(int, optional): The maximum number of returned results per page. The default value is 25 and the maximum value is 500. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.request_validator.get_all(ctx, rest_api_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.request_validator.get_all rest_api_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="get_request_validators",
        op_kwargs={"restApiId": rest_api_id, "position": position, "limit": limit},
    )


async def update(
    hub, ctx, rest_api_id: str, request_validator_id: str, patch_operations: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a RequestValidator of a given RestApi.

    Args:
        rest_api_id(str): [Required] The string identifier of the associated RestApi.
        request_validator_id(str): [Required] The identifier of RequestValidator to be updated.
        patch_operations(List, optional): A list of update operations to be applied to the specified resource and in the order specified in this list. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.request_validator.update(
                ctx, rest_api_id=value, request_validator_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.request_validator.update rest_api_id=value, request_validator_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="update_request_validator",
        op_kwargs={
            "restApiId": rest_api_id,
            "requestValidatorId": request_validator_id,
            "patchOperations": patch_operations,
        },
    )
