"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(hub, ctx, rest_api_id: str, model_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Generates a sample mapping template that can be used to transform a payload into the structure of a model.

    Args:
        rest_api_id(str): [Required] The string identifier of the associated RestApi.
        model_name(str): [Required] The name of the model for which to generate a template.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.model.template.get(
                ctx, rest_api_id=value, model_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.model.template.get rest_api_id=value, model_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="get_model_template",
        op_kwargs={"restApiId": rest_api_id, "modelName": model_name},
    )
