"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    rest_api_id: str,
    name: str,
    content_type: str,
    description: str = None,
    schema: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Adds a new Model resource to an existing RestApi resource.

    Args:
        rest_api_id(str): [Required] The RestApi identifier under which the Model will be created.
        name(str): [Required] The name of the model. Must be alphanumeric.
        description(str, optional): The description of the model. Defaults to None.
        schema(str, optional): The schema for the model. For application/json models, this should be JSON schema draft 4 model. Defaults to None.
        content_type(str): [Required] The content-type for the model.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.model.init.create(
                ctx, rest_api_id=value, name=value, content_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.model.init.create rest_api_id=value, name=value, content_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="create_model",
        op_kwargs={
            "restApiId": rest_api_id,
            "name": name,
            "description": description,
            "schema": schema,
            "contentType": content_type,
        },
    )


async def delete(hub, ctx, rest_api_id: str, model_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes a model.

    Args:
        rest_api_id(str): [Required] The string identifier of the associated RestApi.
        model_name(str): [Required] The name of the model to delete.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.model.init.delete(
                ctx, rest_api_id=value, model_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.model.init.delete rest_api_id=value, model_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="delete_model",
        op_kwargs={"restApiId": rest_api_id, "modelName": model_name},
    )


async def get(
    hub, ctx, rest_api_id: str, model_name: str, flatten: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Describes an existing model defined for a RestApi resource.

    Args:
        rest_api_id(str): [Required] The RestApi identifier under which the Model exists.
        model_name(str): [Required] The name of the model as an identifier.
        flatten(bool, optional): A query parameter of a Boolean value to resolve (true) all external model references and returns a flattened model schema or not (false) The default is false. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.model.init.get(
                ctx, rest_api_id=value, model_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.model.init.get rest_api_id=value, model_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="get_model",
        op_kwargs={
            "restApiId": rest_api_id,
            "modelName": model_name,
            "flatten": flatten,
        },
    )


async def get_all(
    hub, ctx, rest_api_id: str, position: str = None, limit: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Describes existing Models defined for a RestApi resource.

    Args:
        rest_api_id(str): [Required] The string identifier of the associated RestApi.
        position(str, optional): The current pagination position in the paged result set. Defaults to None.
        limit(int, optional): The maximum number of returned results per page. The default value is 25 and the maximum value is 500. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.model.init.get_all(ctx, rest_api_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.model.init.get_all rest_api_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="get_models",
        op_kwargs={"restApiId": rest_api_id, "position": position, "limit": limit},
    )


async def update(
    hub, ctx, rest_api_id: str, model_name: str, patch_operations: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Changes information about a model.

    Args:
        rest_api_id(str): [Required] The string identifier of the associated RestApi.
        model_name(str): [Required] The name of the model to update.
        patch_operations(List, optional): A list of update operations to be applied to the specified resource and in the order specified in this list. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.model.init.update(
                ctx, rest_api_id=value, model_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.model.init.update rest_api_id=value, model_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="update_model",
        op_kwargs={
            "restApiId": rest_api_id,
            "modelName": model_name,
            "patchOperations": patch_operations,
        },
    )
