"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete(
    hub, ctx, rest_api_id: str, resource_id: str, http_method: str, status_code: str
) -> None:
    r"""
    **Autogenerated function**

    Deletes an existing MethodResponse resource.

    Args:
        rest_api_id(str): [Required] The string identifier of the associated RestApi.
        resource_id(str): [Required] The Resource identifier for the MethodResponse resource.
        http_method(str): [Required] The HTTP verb of the Method resource.
        status_code(str): [Required] The status code identifier for the MethodResponse resource.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.method.response.delete(
                ctx, rest_api_id=value, resource_id=value, http_method=value, status_code=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.method.response.delete rest_api_id=value, resource_id=value, http_method=value, status_code=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="delete_method_response",
        op_kwargs={
            "restApiId": rest_api_id,
            "resourceId": resource_id,
            "httpMethod": http_method,
            "statusCode": status_code,
        },
    )


async def get(
    hub, ctx, rest_api_id: str, resource_id: str, http_method: str, status_code: str
) -> Dict:
    r"""
    **Autogenerated function**

    Describes a MethodResponse resource.

    Args:
        rest_api_id(str): [Required] The string identifier of the associated RestApi.
        resource_id(str): [Required] The Resource identifier for the MethodResponse resource.
        http_method(str): [Required] The HTTP verb of the Method resource.
        status_code(str): [Required] The status code for the MethodResponse resource.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.method.response.get(
                ctx, rest_api_id=value, resource_id=value, http_method=value, status_code=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.method.response.get rest_api_id=value, resource_id=value, http_method=value, status_code=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="get_method_response",
        op_kwargs={
            "restApiId": rest_api_id,
            "resourceId": resource_id,
            "httpMethod": http_method,
            "statusCode": status_code,
        },
    )


async def put(
    hub,
    ctx,
    rest_api_id: str,
    resource_id: str,
    http_method: str,
    status_code: str,
    response_parameters: Dict = None,
    response_models: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Adds a MethodResponse to an existing Method resource.

    Args:
        rest_api_id(str): [Required] The string identifier of the associated RestApi.
        resource_id(str): [Required] The Resource identifier for the Method resource.
        http_method(str): [Required] The HTTP verb of the Method resource.
        status_code(str): [Required] The method response's status code.
        response_parameters(Dict, optional): A key-value map specifying required or optional response parameters that API Gateway can send back to the caller. A key defines a method response header name and the associated value is a Boolean flag indicating whether the method response parameter is required or not. The method response header names must match the pattern of method.response.header.{name}, where name is a valid and unique header name. The response parameter names defined here are available in the integration response to be mapped from an integration response header expressed in integration.response.header.{name}, a static value enclosed within a pair of single quotes (e.g., 'application/json'), or a JSON expression from the back-end response payload in the form of integration.response.body.{JSON-expression}, where JSON-expression is a valid JSON expression without the $ prefix.). Defaults to None.
        response_models(Dict, optional): Specifies the Model resources used for the response's content type. Response models are represented as a key/value map, with a content type as the key and a Model name as the value. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.method.response.put(
                ctx, rest_api_id=value, resource_id=value, http_method=value, status_code=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.method.response.put rest_api_id=value, resource_id=value, http_method=value, status_code=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="put_method_response",
        op_kwargs={
            "restApiId": rest_api_id,
            "resourceId": resource_id,
            "httpMethod": http_method,
            "statusCode": status_code,
            "responseParameters": response_parameters,
            "responseModels": response_models,
        },
    )


async def update(
    hub,
    ctx,
    rest_api_id: str,
    resource_id: str,
    http_method: str,
    status_code: str,
    patch_operations: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates an existing MethodResponse resource.

    Args:
        rest_api_id(str): [Required] The string identifier of the associated RestApi.
        resource_id(str): [Required] The Resource identifier for the MethodResponse resource.
        http_method(str): [Required] The HTTP verb of the Method resource.
        status_code(str): [Required] The status code for the MethodResponse resource.
        patch_operations(List, optional): A list of update operations to be applied to the specified resource and in the order specified in this list. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.method.response.update(
                ctx, rest_api_id=value, resource_id=value, http_method=value, status_code=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.method.response.update rest_api_id=value, resource_id=value, http_method=value, status_code=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="update_method_response",
        op_kwargs={
            "restApiId": rest_api_id,
            "resourceId": resource_id,
            "httpMethod": http_method,
            "statusCode": status_code,
            "patchOperations": patch_operations,
        },
    )
