"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete(
    hub, ctx, rest_api_id: str, resource_id: str, http_method: str
) -> None:
    r"""
    **Autogenerated function**

    Deletes an existing Method resource.

    Args:
        rest_api_id(str): [Required] The string identifier of the associated RestApi.
        resource_id(str): [Required] The Resource identifier for the Method resource.
        http_method(str): [Required] The HTTP verb of the Method resource.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.method.init.delete(
                ctx, rest_api_id=value, resource_id=value, http_method=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.method.init.delete rest_api_id=value, resource_id=value, http_method=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="delete_method",
        op_kwargs={
            "restApiId": rest_api_id,
            "resourceId": resource_id,
            "httpMethod": http_method,
        },
    )


async def get(hub, ctx, rest_api_id: str, resource_id: str, http_method: str) -> Dict:
    r"""
    **Autogenerated function**

    Describe an existing Method resource.

    Args:
        rest_api_id(str): [Required] The string identifier of the associated RestApi.
        resource_id(str): [Required] The Resource identifier for the Method resource.
        http_method(str): [Required] Specifies the method request's HTTP method type.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.method.init.get(
                ctx, rest_api_id=value, resource_id=value, http_method=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.method.init.get rest_api_id=value, resource_id=value, http_method=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="get_method",
        op_kwargs={
            "restApiId": rest_api_id,
            "resourceId": resource_id,
            "httpMethod": http_method,
        },
    )


async def put(
    hub,
    ctx,
    rest_api_id: str,
    resource_id: str,
    http_method: str,
    authorization_type: str,
    authorizer_id: str = None,
    api_key_required: bool = None,
    operation_name: str = None,
    request_parameters: Dict = None,
    request_models: Dict = None,
    request_validator_id: str = None,
    authorization_scopes: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Add a method to an existing Resource resource.

    Args:
        rest_api_id(str): [Required] The string identifier of the associated RestApi.
        resource_id(str): [Required] The Resource identifier for the new Method resource.
        http_method(str): [Required] Specifies the method request's HTTP method type.
        authorization_type(str): [Required] The method's authorization type. Valid values are NONE for open access, AWS_IAM for using AWS IAM permissions, CUSTOM for using a custom authorizer, or COGNITO_USER_POOLS for using a Cognito user pool.
        authorizer_id(str, optional): Specifies the identifier of an Authorizer to use on this Method, if the type is CUSTOM or COGNITO_USER_POOLS. The authorizer identifier is generated by API Gateway when you created the authorizer. Defaults to None.
        api_key_required(bool, optional): Specifies whether the method required a valid ApiKey. Defaults to None.
        operation_name(str, optional): A human-friendly operation identifier for the method. For example, you can assign the operationName of ListPets for the GET /pets method in the PetStore example. Defaults to None.
        request_parameters(Dict, optional): A key-value map defining required or optional method request parameters that can be accepted by API Gateway. A key defines a method request parameter name matching the pattern of method.request.{location}.{name}, where location is querystring, path, or header and name is a valid and unique parameter name. The value associated with the key is a Boolean flag indicating whether the parameter is required (true) or optional (false). The method request parameter names defined here are available in Integration to be mapped to integration request parameters or body-mapping templates. Defaults to None.
        request_models(Dict, optional): Specifies the Model resources used for the request's content type. Request models are represented as a key/value map, with a content type as the key and a Model name as the value. Defaults to None.
        request_validator_id(str, optional): The identifier of a RequestValidator for validating the method request. Defaults to None.
        authorization_scopes(List, optional): A list of authorization scopes configured on the method. The scopes are used with a COGNITO_USER_POOLS authorizer to authorize the method invocation. The authorization works by matching the method scopes against the scopes parsed from the access token in the incoming request. The method invocation is authorized if any method scopes matches a claimed scope in the access token. Otherwise, the invocation is not authorized. When the method scope is configured, the client must provide an access token instead of an identity token for authorization purposes. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.method.init.put(
                ctx,
                rest_api_id=value,
                resource_id=value,
                http_method=value,
                authorization_type=value,
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.method.init.put rest_api_id=value, resource_id=value, http_method=value, authorization_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="put_method",
        op_kwargs={
            "restApiId": rest_api_id,
            "resourceId": resource_id,
            "httpMethod": http_method,
            "authorizationType": authorization_type,
            "authorizerId": authorizer_id,
            "apiKeyRequired": api_key_required,
            "operationName": operation_name,
            "requestParameters": request_parameters,
            "requestModels": request_models,
            "requestValidatorId": request_validator_id,
            "authorizationScopes": authorization_scopes,
        },
    )


async def update(
    hub,
    ctx,
    rest_api_id: str,
    resource_id: str,
    http_method: str,
    patch_operations: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates an existing Method resource.

    Args:
        rest_api_id(str): [Required] The string identifier of the associated RestApi.
        resource_id(str): [Required] The Resource identifier for the Method resource.
        http_method(str): [Required] The HTTP verb of the Method resource.
        patch_operations(List, optional): A list of update operations to be applied to the specified resource and in the order specified in this list. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.method.init.update(
                ctx, rest_api_id=value, resource_id=value, http_method=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.method.init.update rest_api_id=value, resource_id=value, http_method=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="update_method",
        op_kwargs={
            "restApiId": rest_api_id,
            "resourceId": resource_id,
            "httpMethod": http_method,
            "patchOperations": patch_operations,
        },
    )
