"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def test(
    hub,
    ctx,
    rest_api_id: str,
    resource_id: str,
    http_method: str,
    path_with_query_string: str = None,
    body: str = None,
    headers: Dict = None,
    multi_value_headers: Dict = None,
    client_certificate_id: str = None,
    stage_variables: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Simulate the execution of a Method in your RestApi with headers, parameters, and an incoming request body.

    Args:
        rest_api_id(str): [Required] The string identifier of the associated RestApi.
        resource_id(str): [Required] Specifies a test invoke method request's resource ID.
        http_method(str): [Required] Specifies a test invoke method request's HTTP method.
        path_with_query_string(str, optional): The URI path, including query string, of the simulated invocation request. Use this to specify path parameters and query string parameters. Defaults to None.
        body(str, optional): The simulated request body of an incoming invocation request. Defaults to None.
        headers(Dict, optional): A key-value map of headers to simulate an incoming invocation request. Defaults to None.
        multi_value_headers(Dict, optional): The headers as a map from string to list of values to simulate an incoming invocation request. Defaults to None.
        client_certificate_id(str, optional): A ClientCertificate identifier to use in the test invocation. API Gateway will use the certificate when making the HTTPS request to the defined back-end endpoint. Defaults to None.
        stage_variables(Dict, optional): A key-value map of stage variables to simulate an invocation on a deployed Stage. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.invoke.method.test(
                ctx, rest_api_id=value, resource_id=value, http_method=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.invoke.method.test rest_api_id=value, resource_id=value, http_method=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="test_invoke_method",
        op_kwargs={
            "restApiId": rest_api_id,
            "resourceId": resource_id,
            "httpMethod": http_method,
            "pathWithQueryString": path_with_query_string,
            "body": body,
            "headers": headers,
            "multiValueHeaders": multi_value_headers,
            "clientCertificateId": client_certificate_id,
            "stageVariables": stage_variables,
        },
    )
