"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def test(
    hub,
    ctx,
    rest_api_id: str,
    authorizer_id: str,
    headers: Dict = None,
    multi_value_headers: Dict = None,
    path_with_query_string: str = None,
    body: str = None,
    stage_variables: Dict = None,
    additional_context: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Simulate the execution of an Authorizer in your RestApi with headers, parameters, and an incoming request body.  Use Lambda Function as Authorizer Use Cognito User Pool as Authorizer

    Args:
        rest_api_id(str): [Required] The string identifier of the associated RestApi.
        authorizer_id(str): [Required] Specifies a test invoke authorizer request's Authorizer ID.
        headers(Dict, optional): [Required] A key-value map of headers to simulate an incoming invocation request. This is where the incoming authorization token, or identity source, should be specified. Defaults to None.
        multi_value_headers(Dict, optional): [Optional] The headers as a map from string to list of values to simulate an incoming invocation request. This is where the incoming authorization token, or identity source, may be specified. Defaults to None.
        path_with_query_string(str, optional): [Optional] The URI path, including query string, of the simulated invocation request. Use this to specify path parameters and query string parameters. Defaults to None.
        body(str, optional): [Optional] The simulated request body of an incoming invocation request. Defaults to None.
        stage_variables(Dict, optional): A key-value map of stage variables to simulate an invocation on a deployed Stage. Defaults to None.
        additional_context(Dict, optional): [Optional] A key-value map of additional context variables. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.invoke.authorizer.test(
                ctx, rest_api_id=value, authorizer_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.invoke.authorizer.test rest_api_id=value, authorizer_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="test_invoke_authorizer",
        op_kwargs={
            "restApiId": rest_api_id,
            "authorizerId": authorizer_id,
            "headers": headers,
            "multiValueHeaders": multi_value_headers,
            "pathWithQueryString": path_with_query_string,
            "body": body,
            "stageVariables": stage_variables,
            "additionalContext": additional_context,
        },
    )
