"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete(
    hub, ctx, rest_api_id: str, resource_id: str, http_method: str, status_code: str
) -> None:
    r"""
    **Autogenerated function**

    Represents a delete integration response.

    Args:
        rest_api_id(str): [Required] The string identifier of the associated RestApi.
        resource_id(str): [Required] Specifies a delete integration response request's resource identifier.
        http_method(str): [Required] Specifies a delete integration response request's HTTP method.
        status_code(str): [Required] Specifies a delete integration response request's status code.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.integration.response.delete(
                ctx, rest_api_id=value, resource_id=value, http_method=value, status_code=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.integration.response.delete rest_api_id=value, resource_id=value, http_method=value, status_code=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="delete_integration_response",
        op_kwargs={
            "restApiId": rest_api_id,
            "resourceId": resource_id,
            "httpMethod": http_method,
            "statusCode": status_code,
        },
    )


async def get(
    hub, ctx, rest_api_id: str, resource_id: str, http_method: str, status_code: str
) -> Dict:
    r"""
    **Autogenerated function**

    Represents a get integration response.

    Args:
        rest_api_id(str): [Required] The string identifier of the associated RestApi.
        resource_id(str): [Required] Specifies a get integration response request's resource identifier.
        http_method(str): [Required] Specifies a get integration response request's HTTP method.
        status_code(str): [Required] Specifies a get integration response request's status code.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.integration.response.get(
                ctx, rest_api_id=value, resource_id=value, http_method=value, status_code=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.integration.response.get rest_api_id=value, resource_id=value, http_method=value, status_code=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="get_integration_response",
        op_kwargs={
            "restApiId": rest_api_id,
            "resourceId": resource_id,
            "httpMethod": http_method,
            "statusCode": status_code,
        },
    )


async def put(
    hub,
    ctx,
    rest_api_id: str,
    resource_id: str,
    http_method: str,
    status_code: str,
    selection_pattern: str = None,
    response_parameters: Dict = None,
    response_templates: Dict = None,
    content_handling: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Represents a put integration.

    Args:
        rest_api_id(str): [Required] The string identifier of the associated RestApi.
        resource_id(str): [Required] Specifies a put integration response request's resource identifier.
        http_method(str): [Required] Specifies a put integration response request's HTTP method.
        status_code(str): [Required] Specifies the status code that is used to map the integration response to an existing MethodResponse.
        selection_pattern(str, optional): Specifies the selection pattern of a put integration response. Defaults to None.
        response_parameters(Dict, optional): A key-value map specifying response parameters that are passed to the method response from the back end. The key is a method response header parameter name and the mapped value is an integration response header value, a static value enclosed within a pair of single quotes, or a JSON expression from the integration response body. The mapping key must match the pattern of method.response.header.{name}, where name is a valid and unique header name. The mapped non-static value must match the pattern of integration.response.header.{name} or integration.response.body.{JSON-expression}, where name must be a valid and unique response header name and JSON-expression a valid JSON expression without the $ prefix. Defaults to None.
        response_templates(Dict, optional): Specifies a put integration response's templates. Defaults to None.
        content_handling(str, optional): Specifies how to handle response payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:  CONVERT_TO_BINARY: Converts a response payload from a Base64-encoded string to the corresponding binary blob. CONVERT_TO_TEXT: Converts a response payload from a binary blob to a Base64-encoded string.  If this property is not defined, the response payload will be passed through from the integration response to the method response without modification. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.integration.response.put(
                ctx, rest_api_id=value, resource_id=value, http_method=value, status_code=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.integration.response.put rest_api_id=value, resource_id=value, http_method=value, status_code=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="put_integration_response",
        op_kwargs={
            "restApiId": rest_api_id,
            "resourceId": resource_id,
            "httpMethod": http_method,
            "statusCode": status_code,
            "selectionPattern": selection_pattern,
            "responseParameters": response_parameters,
            "responseTemplates": response_templates,
            "contentHandling": content_handling,
        },
    )


async def update(
    hub,
    ctx,
    rest_api_id: str,
    resource_id: str,
    http_method: str,
    status_code: str,
    patch_operations: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Represents an update integration response.

    Args:
        rest_api_id(str): [Required] The string identifier of the associated RestApi.
        resource_id(str): [Required] Specifies an update integration response request's resource identifier.
        http_method(str): [Required] Specifies an update integration response request's HTTP method.
        status_code(str): [Required] Specifies an update integration response request's status code.
        patch_operations(List, optional): A list of update operations to be applied to the specified resource and in the order specified in this list. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.integration.response.update(
                ctx, rest_api_id=value, resource_id=value, http_method=value, status_code=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.integration.response.update rest_api_id=value, resource_id=value, http_method=value, status_code=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="update_integration_response",
        op_kwargs={
            "restApiId": rest_api_id,
            "resourceId": resource_id,
            "httpMethod": http_method,
            "statusCode": status_code,
            "patchOperations": patch_operations,
        },
    )
