"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete(
    hub, ctx, rest_api_id: str, resource_id: str, http_method: str
) -> None:
    r"""
    **Autogenerated function**

    Represents a delete integration.

    Args:
        rest_api_id(str): [Required] The string identifier of the associated RestApi.
        resource_id(str): [Required] Specifies a delete integration request's resource identifier.
        http_method(str): [Required] Specifies a delete integration request's HTTP method.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.integration.init.delete(
                ctx, rest_api_id=value, resource_id=value, http_method=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.integration.init.delete rest_api_id=value, resource_id=value, http_method=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="delete_integration",
        op_kwargs={
            "restApiId": rest_api_id,
            "resourceId": resource_id,
            "httpMethod": http_method,
        },
    )


async def get(hub, ctx, rest_api_id: str, resource_id: str, http_method: str) -> Dict:
    r"""
    **Autogenerated function**

    Get the integration settings.

    Args:
        rest_api_id(str): [Required] The string identifier of the associated RestApi.
        resource_id(str): [Required] Specifies a get integration request's resource identifier.
        http_method(str): [Required] Specifies a get integration request's HTTP method.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.integration.init.get(
                ctx, rest_api_id=value, resource_id=value, http_method=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.integration.init.get rest_api_id=value, resource_id=value, http_method=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="get_integration",
        op_kwargs={
            "restApiId": rest_api_id,
            "resourceId": resource_id,
            "httpMethod": http_method,
        },
    )


async def put(
    hub,
    ctx,
    rest_api_id: str,
    resource_id: str,
    http_method: str,
    type_: str,
    integration_http_method: str = None,
    uri: str = None,
    connection_type: str = None,
    connection_id: str = None,
    credentials: str = None,
    request_parameters: Dict = None,
    request_templates: Dict = None,
    passthrough_behavior: str = None,
    cache_namespace: str = None,
    cache_key_parameters: List = None,
    content_handling: str = None,
    timeout_in_millis: int = None,
    tls_config: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Sets up a method's integration.

    Args:
        rest_api_id(str): [Required] The string identifier of the associated RestApi.
        resource_id(str): [Required] Specifies a put integration request's resource ID.
        http_method(str): [Required] Specifies a put integration request's HTTP method.
        type_(str): [Required] Specifies a put integration input's type.
        integration_http_method(str, optional): Specifies a put integration HTTP method. When the integration type is HTTP or AWS, this field is required. Defaults to None.
        uri(str, optional): Specifies Uniform Resource Identifier (URI) of the integration endpoint.   For HTTP or HTTP_PROXY integrations, the URI must be a fully formed, encoded HTTP(S) URL according to the RFC-3986 specification, for either standard integration, where connectionType is not VPC_LINK, or private integration, where connectionType is VPC_LINK. For a private HTTP integration, the URI is not used for routing.    For AWS or AWS_PROXY integrations, the URI is of the form arn:aws:apigateway:{region}:{subdomain.service|service}:path|action/{service_api}. Here, {Region} is the API Gateway region (e.g., us-east-1); {service} is the name of the integrated AWS service (e.g., s3); and {subdomain} is a designated subdomain supported by certain AWS service for fast host-name lookup. action can be used for an AWS service action-based API, using an Action={name}&{p1}={v1}&p2={v2}... query string. The ensuing {service_api} refers to a supported action {name} plus any required input parameters. Alternatively, path can be used for an AWS service path-based API. The ensuing service_api refers to the path to an AWS service resource, including the region of the integrated AWS service, if applicable. For example, for integration with the S3 API of GetObject, the uri can be either arn:aws:apigateway:us-west-2:s3:action/GetObject&Bucket={bucket}&Key={key} or arn:aws:apigateway:us-west-2:s3:path/{bucket}/{key} . Defaults to None.
        connection_type(str, optional): The type of the network connection to the integration endpoint. The valid value is INTERNET for connections through the public routable internet or VPC_LINK for private connections between API Gateway and a network load balancer in a VPC. The default value is INTERNET. Defaults to None.
        connection_id(str, optional): The (id) of the VpcLink used for the integration when connectionType=VPC_LINK and undefined, otherwise. Defaults to None.
        credentials(str, optional): Specifies whether credentials are required for a put integration. Defaults to None.
        request_parameters(Dict, optional): A key-value map specifying request parameters that are passed from the method request to the back end. The key is an integration request parameter name and the associated value is a method request parameter value or static value that must be enclosed within single quotes and pre-encoded as required by the back end. The method request parameter value must match the pattern of method.request.{location}.{name}, where location is querystring, path, or header and name must be a valid and unique method request parameter name. Defaults to None.
        request_templates(Dict, optional): Represents a map of Velocity templates that are applied on the request payload based on the value of the Content-Type header sent by the client. The content type value is the key in this map, and the template (as a String) is the value. Defaults to None.
        passthrough_behavior(str, optional): Specifies the pass-through behavior for incoming requests based on the Content-Type header in the request, and the available mapping templates specified as the requestTemplates property on the Integration resource. There are three valid values: WHEN_NO_MATCH, WHEN_NO_TEMPLATES, and NEVER.   WHEN_NO_MATCH passes the request body for unmapped content types through to the integration back end without transformation. NEVER rejects unmapped content types with an HTTP 415 'Unsupported Media Type' response. WHEN_NO_TEMPLATES allows pass-through when the integration has NO content types mapped to templates. However if there is at least one content type defined, unmapped content types will be rejected with the same 415 response. . Defaults to None.
        cache_namespace(str, optional): Specifies a group of related cached parameters. By default, API Gateway uses the resource ID as the cacheNamespace. You can specify the same cacheNamespace across resources to return the same cached data for requests to different resources. Defaults to None.
        cache_key_parameters(List, optional): A list of request parameters whose values API Gateway caches. To be valid values for cacheKeyParameters, these parameters must also be specified for Method requestParameters. Defaults to None.
        content_handling(str, optional): Specifies how to handle request payload content type conversions. Supported values are CONVERT_TO_BINARY and CONVERT_TO_TEXT, with the following behaviors:  CONVERT_TO_BINARY: Converts a request payload from a Base64-encoded string to the corresponding binary blob. CONVERT_TO_TEXT: Converts a request payload from a binary blob to a Base64-encoded string.  If this property is not defined, the request payload will be passed through from the method request to integration request without modification, provided that the passthroughBehavior is configured to support payload pass-through. Defaults to None.
        timeout_in_millis(int, optional): Custom timeout between 50 and 29,000 milliseconds. The default value is 29,000 milliseconds or 29 seconds. Defaults to None.
        tls_config(Dict, optional): . Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.integration.init.put(
                ctx, rest_api_id=value, resource_id=value, http_method=value, type_=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.integration.init.put rest_api_id=value, resource_id=value, http_method=value, type_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="put_integration",
        op_kwargs={
            "restApiId": rest_api_id,
            "resourceId": resource_id,
            "httpMethod": http_method,
            "type": type_,
            "integrationHttpMethod": integration_http_method,
            "uri": uri,
            "connectionType": connection_type,
            "connectionId": connection_id,
            "credentials": credentials,
            "requestParameters": request_parameters,
            "requestTemplates": request_templates,
            "passthroughBehavior": passthrough_behavior,
            "cacheNamespace": cache_namespace,
            "cacheKeyParameters": cache_key_parameters,
            "contentHandling": content_handling,
            "timeoutInMillis": timeout_in_millis,
            "tlsConfig": tls_config,
        },
    )


async def update(
    hub,
    ctx,
    rest_api_id: str,
    resource_id: str,
    http_method: str,
    patch_operations: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Represents an update integration.

    Args:
        rest_api_id(str): [Required] The string identifier of the associated RestApi.
        resource_id(str): [Required] Represents an update integration request's resource identifier.
        http_method(str): [Required] Represents an update integration request's HTTP method.
        patch_operations(List, optional): A list of update operations to be applied to the specified resource and in the order specified in this list. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.integration.init.update(
                ctx, rest_api_id=value, resource_id=value, http_method=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.integration.init.update rest_api_id=value, resource_id=value, http_method=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="update_integration",
        op_kwargs={
            "restApiId": rest_api_id,
            "resourceId": resource_id,
            "httpMethod": http_method,
            "patchOperations": patch_operations,
        },
    )
