"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete(hub, ctx, rest_api_id: str, response_type: str) -> None:
    r"""
    **Autogenerated function**

    Clears any customization of a GatewayResponse of a specified response type on the given RestApi and resets it with the default settings.

    Args:
        rest_api_id(str): [Required] The string identifier of the associated RestApi.
        response_type(str): [Required] The response type of the associated GatewayResponse. Valid values are ACCESS_DENIEDAPI_CONFIGURATION_ERRORAUTHORIZER_FAILURE AUTHORIZER_CONFIGURATION_ERRORBAD_REQUEST_PARAMETERSBAD_REQUEST_BODYDEFAULT_4XXDEFAULT_5XXEXPIRED_TOKENINVALID_SIGNATUREINTEGRATION_FAILUREINTEGRATION_TIMEOUTINVALID_API_KEYMISSING_AUTHENTICATION_TOKEN QUOTA_EXCEEDEDREQUEST_TOO_LARGERESOURCE_NOT_FOUNDTHROTTLEDUNAUTHORIZEDUNSUPPORTED_MEDIA_TYPE .
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.gateway_response.delete(
                ctx, rest_api_id=value, response_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.gateway_response.delete rest_api_id=value, response_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="delete_gateway_response",
        op_kwargs={"restApiId": rest_api_id, "responseType": response_type},
    )


async def get(hub, ctx, rest_api_id: str, response_type: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets a GatewayResponse of a specified response type on the given RestApi.

    Args:
        rest_api_id(str): [Required] The string identifier of the associated RestApi.
        response_type(str): [Required] The response type of the associated GatewayResponse. Valid values are ACCESS_DENIEDAPI_CONFIGURATION_ERRORAUTHORIZER_FAILURE AUTHORIZER_CONFIGURATION_ERRORBAD_REQUEST_PARAMETERSBAD_REQUEST_BODYDEFAULT_4XXDEFAULT_5XXEXPIRED_TOKENINVALID_SIGNATUREINTEGRATION_FAILUREINTEGRATION_TIMEOUTINVALID_API_KEYMISSING_AUTHENTICATION_TOKEN QUOTA_EXCEEDEDREQUEST_TOO_LARGERESOURCE_NOT_FOUNDTHROTTLEDUNAUTHORIZEDUNSUPPORTED_MEDIA_TYPE .

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.gateway_response.get(
                ctx, rest_api_id=value, response_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.gateway_response.get rest_api_id=value, response_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="get_gateway_response",
        op_kwargs={"restApiId": rest_api_id, "responseType": response_type},
    )


async def get_all(
    hub, ctx, rest_api_id: str, position: str = None, limit: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Gets the GatewayResponses collection on the given RestApi. If an API developer has not added any definitions for gateway responses, the result will be the API Gateway-generated default GatewayResponses collection for the supported response types.

    Args:
        rest_api_id(str): [Required] The string identifier of the associated RestApi.
        position(str, optional): The current pagination position in the paged result set. The GatewayResponse collection does not support pagination and the position does not apply here. Defaults to None.
        limit(int, optional): The maximum number of returned results per page. The default value is 25 and the maximum value is 500. The GatewayResponses collection does not support pagination and the limit does not apply here. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.gateway_response.get_all(ctx, rest_api_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.gateway_response.get_all rest_api_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="get_gateway_responses",
        op_kwargs={"restApiId": rest_api_id, "position": position, "limit": limit},
    )


async def put(
    hub,
    ctx,
    rest_api_id: str,
    response_type: str,
    status_code: str = None,
    response_parameters: Dict = None,
    response_templates: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a customization of a GatewayResponse of a specified response type and status code on the given RestApi.

    Args:
        rest_api_id(str): [Required] The string identifier of the associated RestApi.
        response_type(str): [Required] The response type of the associated GatewayResponse. Valid values are ACCESS_DENIEDAPI_CONFIGURATION_ERRORAUTHORIZER_FAILURE AUTHORIZER_CONFIGURATION_ERRORBAD_REQUEST_PARAMETERSBAD_REQUEST_BODYDEFAULT_4XXDEFAULT_5XXEXPIRED_TOKENINVALID_SIGNATUREINTEGRATION_FAILUREINTEGRATION_TIMEOUTINVALID_API_KEYMISSING_AUTHENTICATION_TOKEN QUOTA_EXCEEDEDREQUEST_TOO_LARGERESOURCE_NOT_FOUNDTHROTTLEDUNAUTHORIZEDUNSUPPORTED_MEDIA_TYPE .
        status_code(str, optional): The HTTP status code of the GatewayResponse. Defaults to None.
        response_parameters(Dict, optional): Response parameters (paths, query strings and headers) of the GatewayResponse as a string-to-string map of key-value pairs. Defaults to None.
        response_templates(Dict, optional): Response templates of the GatewayResponse as a string-to-string map of key-value pairs. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.gateway_response.put(
                ctx, rest_api_id=value, response_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.gateway_response.put rest_api_id=value, response_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="put_gateway_response",
        op_kwargs={
            "restApiId": rest_api_id,
            "responseType": response_type,
            "statusCode": status_code,
            "responseParameters": response_parameters,
            "responseTemplates": response_templates,
        },
    )


async def update(
    hub, ctx, rest_api_id: str, response_type: str, patch_operations: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a GatewayResponse of a specified response type on the given RestApi.

    Args:
        rest_api_id(str): [Required] The string identifier of the associated RestApi.
        response_type(str): [Required] The response type of the associated GatewayResponse. Valid values are ACCESS_DENIEDAPI_CONFIGURATION_ERRORAUTHORIZER_FAILURE AUTHORIZER_CONFIGURATION_ERRORBAD_REQUEST_PARAMETERSBAD_REQUEST_BODYDEFAULT_4XXDEFAULT_5XXEXPIRED_TOKENINVALID_SIGNATUREINTEGRATION_FAILUREINTEGRATION_TIMEOUTINVALID_API_KEYMISSING_AUTHENTICATION_TOKEN QUOTA_EXCEEDEDREQUEST_TOO_LARGERESOURCE_NOT_FOUNDTHROTTLEDUNAUTHORIZEDUNSUPPORTED_MEDIA_TYPE .
        patch_operations(List, optional): A list of update operations to be applied to the specified resource and in the order specified in this list. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.gateway_response.update(
                ctx, rest_api_id=value, response_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.gateway_response.update rest_api_id=value, response_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="update_gateway_response",
        op_kwargs={
            "restApiId": rest_api_id,
            "responseType": response_type,
            "patchOperations": patch_operations,
        },
    )
