"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub,
    ctx,
    rest_api_id: str,
    stage_name: str,
    export_type: str,
    parameters: Dict = None,
    accepts: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Exports a deployed version of a RestApi in a specified format.

    Args:
        rest_api_id(str): [Required] The string identifier of the associated RestApi.
        stage_name(str): [Required] The name of the Stage that will be exported.
        export_type(str): [Required] The type of export. Acceptable values are 'oas30' for OpenAPI 3.0.x and 'swagger' for Swagger/OpenAPI 2.0.
        parameters(Dict, optional): A key-value map of query string parameters that specify properties of the export, depending on the requested exportType. For exportType oas30 and swagger, any combination of the following parameters are supported: extensions='integrations' or extensions='apigateway' will export the API with x-amazon-apigateway-integration extensions. extensions='authorizers' will export the API with x-amazon-apigateway-authorizer extensions. postman will export the API with Postman extensions, allowing for import to the Postman tool. Defaults to None.
        accepts(str, optional): The content-type of the export, for example application/json. Currently application/json and application/yaml are supported for exportType ofoas30 and swagger. This should be specified in the Accept header for direct API requests. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.export.get(
                ctx, rest_api_id=value, stage_name=value, export_type=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.export.get rest_api_id=value, stage_name=value, export_type=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="get_export",
        op_kwargs={
            "restApiId": rest_api_id,
            "stageName": stage_name,
            "exportType": export_type,
            "parameters": parameters,
            "accepts": accepts,
        },
    )
