"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    domain_name: str,
    certificate_name: str = None,
    certificate_body: str = None,
    certificate_private_key: str = None,
    certificate_chain: str = None,
    certificate_arn: str = None,
    regional_certificate_name: str = None,
    regional_certificate_arn: str = None,
    endpoint_configuration: Dict = None,
    tags: Dict = None,
    security_policy: str = None,
    mutual_tls_authentication: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new domain name.

    Args:
        domain_name(str): [Required] The name of the DomainName resource.
        certificate_name(str, optional): The user-friendly name of the certificate that will be used by edge-optimized endpoint for this domain name. Defaults to None.
        certificate_body(str, optional): [Deprecated] The body of the server certificate that will be used by edge-optimized endpoint for this domain name provided by your certificate authority. Defaults to None.
        certificate_private_key(str, optional): [Deprecated] Your edge-optimized endpoint's domain name certificate's private key. Defaults to None.
        certificate_chain(str, optional): [Deprecated] The intermediate certificates and optionally the root certificate, one after the other without any blank lines, used by an edge-optimized endpoint for this domain name. If you include the root certificate, your certificate chain must start with intermediate certificates and end with the root certificate. Use the intermediate certificates that were provided by your certificate authority. Do not include any intermediaries that are not in the chain of trust path. Defaults to None.
        certificate_arn(str, optional): The reference to an AWS-managed certificate that will be used by edge-optimized endpoint for this domain name. AWS Certificate Manager is the only supported source. Defaults to None.
        regional_certificate_name(str, optional): The user-friendly name of the certificate that will be used by regional endpoint for this domain name. Defaults to None.
        regional_certificate_arn(str, optional): The reference to an AWS-managed certificate that will be used by regional endpoint for this domain name. AWS Certificate Manager is the only supported source. Defaults to None.
        endpoint_configuration(Dict, optional): The endpoint configuration of this DomainName showing the endpoint types of the domain name. Defaults to None.
        tags(Dict, optional): The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with aws:. The tag value can be up to 256 characters. Defaults to None.
        security_policy(str, optional): The Transport Layer Security (TLS) version + cipher suite for this DomainName. The valid values are TLS_1_0 and TLS_1_2. Defaults to None.
        mutual_tls_authentication(Dict, optional): If specified, API Gateway performs two-way authentication between the client and the server. Clients must present a trusted certificate to access your custom domain name. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.domain_name.create(ctx, domain_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.domain_name.create domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="create_domain_name",
        op_kwargs={
            "domainName": domain_name,
            "certificateName": certificate_name,
            "certificateBody": certificate_body,
            "certificatePrivateKey": certificate_private_key,
            "certificateChain": certificate_chain,
            "certificateArn": certificate_arn,
            "regionalCertificateName": regional_certificate_name,
            "regionalCertificateArn": regional_certificate_arn,
            "endpointConfiguration": endpoint_configuration,
            "tags": tags,
            "securityPolicy": security_policy,
            "mutualTlsAuthentication": mutual_tls_authentication,
        },
    )


async def delete(hub, ctx, domain_name: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the DomainName resource.

    Args:
        domain_name(str): [Required] The name of the DomainName resource to be deleted.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.domain_name.delete(ctx, domain_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.domain_name.delete domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="delete_domain_name",
        op_kwargs={"domainName": domain_name},
    )


async def get(hub, ctx, domain_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Represents a domain name that is contained in a simpler, more intuitive URL that can be called.

    Args:
        domain_name(str): [Required] The name of the DomainName resource.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.domain_name.get(ctx, domain_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.domain_name.get domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="get_domain_name",
        op_kwargs={"domainName": domain_name},
    )


async def get_all(hub, ctx, position: str = None, limit: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Represents a collection of DomainName resources.

    Args:
        position(str, optional): The current pagination position in the paged result set. Defaults to None.
        limit(int, optional): The maximum number of returned results per page. The default value is 25 and the maximum value is 500. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.domain_name.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.domain_name.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="get_domain_names",
        op_kwargs={"position": position, "limit": limit},
    )


async def update(hub, ctx, domain_name: str, patch_operations: List = None) -> Dict:
    r"""
    **Autogenerated function**

    Changes information about the DomainName resource.

    Args:
        domain_name(str): [Required] The name of the DomainName resource to be changed.
        patch_operations(List, optional): A list of update operations to be applied to the specified resource and in the order specified in this list. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.domain_name.update(ctx, domain_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.domain_name.update domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="update_domain_name",
        op_kwargs={"domainName": domain_name, "patchOperations": patch_operations},
    )
