"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    rest_api_id: str,
    documentation_version: str,
    stage_name: str = None,
    description: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Args:
        rest_api_id(str): [Required] The string identifier of the associated RestApi.
        documentation_version(str): [Required] The version identifier of the new snapshot.
        stage_name(str, optional): The stage name to be associated with the new documentation snapshot. Defaults to None.
        description(str, optional): A description about the new documentation snapshot. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.documentation.version.create(
                ctx, rest_api_id=value, documentation_version=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.documentation.version.create rest_api_id=value, documentation_version=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="create_documentation_version",
        op_kwargs={
            "restApiId": rest_api_id,
            "documentationVersion": documentation_version,
            "stageName": stage_name,
            "description": description,
        },
    )


async def delete(hub, ctx, rest_api_id: str, documentation_version: str) -> None:
    r"""
    **Autogenerated function**

    Args:
        rest_api_id(str): [Required] The string identifier of the associated RestApi.
        documentation_version(str): [Required] The version identifier of a to-be-deleted documentation snapshot.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.documentation.version.delete(
                ctx, rest_api_id=value, documentation_version=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.documentation.version.delete rest_api_id=value, documentation_version=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="delete_documentation_version",
        op_kwargs={
            "restApiId": rest_api_id,
            "documentationVersion": documentation_version,
        },
    )


async def get(hub, ctx, rest_api_id: str, documentation_version: str) -> Dict:
    r"""
    **Autogenerated function**

    Args:
        rest_api_id(str): [Required] The string identifier of the associated RestApi.
        documentation_version(str): [Required] The version identifier of the to-be-retrieved documentation snapshot.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.documentation.version.get(
                ctx, rest_api_id=value, documentation_version=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.documentation.version.get rest_api_id=value, documentation_version=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="get_documentation_version",
        op_kwargs={
            "restApiId": rest_api_id,
            "documentationVersion": documentation_version,
        },
    )


async def get_all(
    hub, ctx, rest_api_id: str, position: str = None, limit: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Args:
        rest_api_id(str): [Required] The string identifier of the associated RestApi.
        position(str, optional): The current pagination position in the paged result set. Defaults to None.
        limit(int, optional): The maximum number of returned results per page. The default value is 25 and the maximum value is 500. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.documentation.version.get_all(ctx, rest_api_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.documentation.version.get_all rest_api_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="get_documentation_versions",
        op_kwargs={"restApiId": rest_api_id, "position": position, "limit": limit},
    )


async def update(
    hub,
    ctx,
    rest_api_id: str,
    documentation_version: str,
    patch_operations: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Args:
        rest_api_id(str): [Required] The string identifier of the associated RestApi..
        documentation_version(str): [Required] The version identifier of the to-be-updated documentation version.
        patch_operations(List, optional): A list of update operations to be applied to the specified resource and in the order specified in this list. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.documentation.version.update(
                ctx, rest_api_id=value, documentation_version=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.documentation.version.update rest_api_id=value, documentation_version=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="update_documentation_version",
        op_kwargs={
            "restApiId": rest_api_id,
            "documentationVersion": documentation_version,
            "patchOperations": patch_operations,
        },
    )
