"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__func_alias__ = {"import_": "import"}


async def create(hub, ctx, rest_api_id: str, location: Dict, properties: str) -> Dict:
    r"""
    **Autogenerated function**

    Args:
        rest_api_id(str): [Required] The string identifier of the associated RestApi.
        location(Dict): [Required] The location of the targeted API entity of the to-be-created documentation part.
        properties(str): [Required] The new documentation content map of the targeted API entity. Enclosed key-value pairs are API-specific, but only OpenAPI-compliant key-value pairs can be exported and, hence, published.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.documentation.part.create(ctx, rest_api_id=value, location=value, properties=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.documentation.part.create rest_api_id=value, location=value, properties=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="create_documentation_part",
        op_kwargs={
            "restApiId": rest_api_id,
            "location": location,
            "properties": properties,
        },
    )


async def delete(hub, ctx, rest_api_id: str, documentation_part_id: str) -> None:
    r"""
    **Autogenerated function**

    Args:
        rest_api_id(str): [Required] The string identifier of the associated RestApi.
        documentation_part_id(str): [Required] The identifier of the to-be-deleted documentation part.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.documentation.part.delete(ctx, rest_api_id=value, documentation_part_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.documentation.part.delete rest_api_id=value, documentation_part_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="delete_documentation_part",
        op_kwargs={
            "restApiId": rest_api_id,
            "documentationPartId": documentation_part_id,
        },
    )


async def get(hub, ctx, rest_api_id: str, documentation_part_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Args:
        rest_api_id(str): [Required] The string identifier of the associated RestApi.
        documentation_part_id(str): [Required] The string identifier of the associated RestApi.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.documentation.part.get(ctx, rest_api_id=value, documentation_part_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.documentation.part.get rest_api_id=value, documentation_part_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="get_documentation_part",
        op_kwargs={
            "restApiId": rest_api_id,
            "documentationPartId": documentation_part_id,
        },
    )


async def get_all(
    hub,
    ctx,
    rest_api_id: str,
    type_: str = None,
    name_query: str = None,
    path: str = None,
    position: str = None,
    limit: int = None,
    location_status: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Args:
        rest_api_id(str): [Required] The string identifier of the associated RestApi.
        type_(str, optional): The type of API entities of the to-be-retrieved documentation parts. . Defaults to None.
        name_query(str, optional): The name of API entities of the to-be-retrieved documentation parts. Defaults to None.
        path(str, optional): The path of API entities of the to-be-retrieved documentation parts. Defaults to None.
        position(str, optional): The current pagination position in the paged result set. Defaults to None.
        limit(int, optional): The maximum number of returned results per page. The default value is 25 and the maximum value is 500. Defaults to None.
        location_status(str, optional): The status of the API documentation parts to retrieve. Valid values are DOCUMENTED for retrieving DocumentationPart resources with content and UNDOCUMENTED for DocumentationPart resources without content. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.documentation.part.get_all(ctx, rest_api_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.documentation.part.get_all rest_api_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="get_documentation_parts",
        op_kwargs={
            "restApiId": rest_api_id,
            "type": type_,
            "nameQuery": name_query,
            "path": path,
            "position": position,
            "limit": limit,
            "locationStatus": location_status,
        },
    )


async def import_(
    hub,
    ctx,
    rest_api_id: str,
    body: bytes,
    mode: str = None,
    fail_on_warnings: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Args:
        rest_api_id(str): [Required] The string identifier of the associated RestApi.
        mode(str, optional): A query parameter to indicate whether to overwrite (OVERWRITE) any existing DocumentationParts definition or to merge (MERGE) the new definition into the existing one. The default value is MERGE. Defaults to None.
        fail_on_warnings(bool, optional): A query parameter to specify whether to rollback the documentation importation (true) or not (false) when a warning is encountered. The default value is false. Defaults to None.
        body(bytes): [Required] Raw byte array representing the to-be-imported documentation parts. To import from an OpenAPI file, this is a JSON object.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.documentation.part.import(ctx, rest_api_id=value, body=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.documentation.part.import rest_api_id=value, body=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="import_documentation_parts",
        op_kwargs={
            "restApiId": rest_api_id,
            "mode": mode,
            "failOnWarnings": fail_on_warnings,
            "body": body,
        },
    )


async def update(
    hub,
    ctx,
    rest_api_id: str,
    documentation_part_id: str,
    patch_operations: List = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Args:
        rest_api_id(str): [Required] The string identifier of the associated RestApi.
        documentation_part_id(str): [Required] The identifier of the to-be-updated documentation part.
        patch_operations(List, optional): A list of update operations to be applied to the specified resource and in the order specified in this list. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.documentation.part.update(ctx, rest_api_id=value, documentation_part_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.documentation.part.update rest_api_id=value, documentation_part_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="update_documentation_part",
        op_kwargs={
            "restApiId": rest_api_id,
            "documentationPartId": documentation_part_id,
            "patchOperations": patch_operations,
        },
    )
