"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def delete(hub, ctx, client_certificate_id: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the ClientCertificate resource.

    Args:
        client_certificate_id(str): [Required] The identifier of the ClientCertificate resource to be deleted.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.client_certificate.delete(
                ctx, client_certificate_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.client_certificate.delete client_certificate_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="delete_client_certificate",
        op_kwargs={"clientCertificateId": client_certificate_id},
    )


async def generate(hub, ctx, description: str = None, tags: Dict = None) -> Dict:
    r"""
    **Autogenerated function**

    Generates a ClientCertificate resource.

    Args:
        description(str, optional): The description of the ClientCertificate. Defaults to None.
        tags(Dict, optional): The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with aws:. The tag value can be up to 256 characters. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.client_certificate.generate(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.client_certificate.generate
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="generate_client_certificate",
        op_kwargs={"description": description, "tags": tags},
    )


async def get(hub, ctx, client_certificate_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about the current ClientCertificate resource.

    Args:
        client_certificate_id(str): [Required] The identifier of the ClientCertificate resource to be described.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.client_certificate.get(
                ctx, client_certificate_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.client_certificate.get client_certificate_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="get_client_certificate",
        op_kwargs={"clientCertificateId": client_certificate_id},
    )


async def get_all(hub, ctx, position: str = None, limit: int = None) -> Dict:
    r"""
    **Autogenerated function**

    Gets a collection of ClientCertificate resources.

    Args:
        position(str, optional): The current pagination position in the paged result set. Defaults to None.
        limit(int, optional): The maximum number of returned results per page. The default value is 25 and the maximum value is 500. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.client_certificate.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.client_certificate.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="get_client_certificates",
        op_kwargs={"position": position, "limit": limit},
    )


async def update(
    hub, ctx, client_certificate_id: str, patch_operations: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Changes information about an ClientCertificate resource.

    Args:
        client_certificate_id(str): [Required] The identifier of the ClientCertificate resource to be updated.
        patch_operations(List, optional): A list of update operations to be applied to the specified resource and in the order specified in this list. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.client_certificate.update(
                ctx, client_certificate_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.client_certificate.update client_certificate_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="update_client_certificate",
        op_kwargs={
            "clientCertificateId": client_certificate_id,
            "patchOperations": patch_operations,
        },
    )
