"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    domain_name: str,
    rest_api_id: str,
    base_path: str = None,
    stage: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new BasePathMapping resource.

    Args:
        domain_name(str): [Required] The domain name of the BasePathMapping resource to create.
        base_path(str, optional): The base path name that callers of the API must provide as part of the URL after the domain name. This value must be unique for all of the mappings across a single API. Specify '(none)' if you do not want callers to specify a base path name after the domain name. Defaults to None.
        rest_api_id(str): [Required] The string identifier of the associated RestApi.
        stage(str, optional): The name of the API's stage that you want to use for this mapping. Specify '(none)' if you want callers to explicitly specify the stage name after any base path name. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.base_path_mapping.create(
                ctx, domain_name=value, rest_api_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.base_path_mapping.create domain_name=value, rest_api_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="create_base_path_mapping",
        op_kwargs={
            "domainName": domain_name,
            "basePath": base_path,
            "restApiId": rest_api_id,
            "stage": stage,
        },
    )


async def delete(hub, ctx, domain_name: str, base_path: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the BasePathMapping resource.

    Args:
        domain_name(str): [Required] The domain name of the BasePathMapping resource to delete.
        base_path(str): [Required] The base path name of the BasePathMapping resource to delete. To specify an empty base path, set this parameter to '(none)'.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.base_path_mapping.delete(
                ctx, domain_name=value, base_path=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.base_path_mapping.delete domain_name=value, base_path=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="delete_base_path_mapping",
        op_kwargs={"domainName": domain_name, "basePath": base_path},
    )


async def get(hub, ctx, domain_name: str, base_path: str) -> Dict:
    r"""
    **Autogenerated function**

    Describe a BasePathMapping resource.

    Args:
        domain_name(str): [Required] The domain name of the BasePathMapping resource to be described.
        base_path(str): [Required] The base path name that callers of the API must provide as part of the URL after the domain name. This value must be unique for all of the mappings across a single API. Specify '(none)' if you do not want callers to specify any base path name after the domain name.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.base_path_mapping.get(
                ctx, domain_name=value, base_path=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.base_path_mapping.get domain_name=value, base_path=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="get_base_path_mapping",
        op_kwargs={"domainName": domain_name, "basePath": base_path},
    )


async def get_all(
    hub, ctx, domain_name: str, position: str = None, limit: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Represents a collection of BasePathMapping resources.

    Args:
        domain_name(str): [Required] The domain name of a BasePathMapping resource.
        position(str, optional): The current pagination position in the paged result set. Defaults to None.
        limit(int, optional): The maximum number of returned results per page. The default value is 25 and the maximum value is 500. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.base_path_mapping.get_all(ctx, domain_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.base_path_mapping.get_all domain_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="get_base_path_mappings",
        op_kwargs={"domainName": domain_name, "position": position, "limit": limit},
    )


async def update(
    hub, ctx, domain_name: str, base_path: str, patch_operations: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Changes information about the BasePathMapping resource.

    Args:
        domain_name(str): [Required] The domain name of the BasePathMapping resource to change.
        base_path(str): [Required] The base path of the BasePathMapping resource to change. To specify an empty base path, set this parameter to '(none)'.
        patch_operations(List, optional): A list of update operations to be applied to the specified resource and in the order specified in this list. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.base_path_mapping.update(
                ctx, domain_name=value, base_path=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.base_path_mapping.update domain_name=value, base_path=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="update_base_path_mapping",
        op_kwargs={
            "domainName": domain_name,
            "basePath": base_path,
            "patchOperations": patch_operations,
        },
    )
