"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def create(
    hub,
    ctx,
    rest_api_id: str,
    name: str,
    type_: str,
    provider_ar_ns: List = None,
    auth_type: str = None,
    authorizer_uri: str = None,
    authorizer_credentials: str = None,
    identity_source: str = None,
    identity_validation_expression: str = None,
    authorizer_result_ttl_in_seconds: int = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Adds a new Authorizer resource to an existing RestApi resource. AWS CLI

    Args:
        rest_api_id(str): [Required] The string identifier of the associated RestApi.
        name(str): [Required] The name of the authorizer.
        type_(str): [Required] The authorizer type. Valid values are TOKEN for a Lambda function using a single authorization token submitted in a custom header, REQUEST for a Lambda function using incoming request parameters, and COGNITO_USER_POOLS for using an Amazon Cognito user pool.
        provider_ar_ns(List, optional): A list of the Amazon Cognito user pool ARNs for the COGNITO_USER_POOLS authorizer. Each element is of this format: arn:aws:cognito-idp:{region}:{account_id}:userpool/{user_pool_id}. For a TOKEN or REQUEST authorizer, this is not defined. Defaults to None.
        auth_type(str, optional): Optional customer-defined field, used in OpenAPI imports and exports without functional impact. Defaults to None.
        authorizer_uri(str, optional): Specifies the authorizer's Uniform Resource Identifier (URI). For TOKEN or REQUEST authorizers, this must be a well-formed Lambda function URI, for example, arn:aws:apigateway:us-west-2:lambda:path/2015-03-31/functions/arn:aws:lambda:us-west-2:{account_id}:function:{lambda_function_name}/invocations. In general, the URI has this form arn:aws:apigateway:{region}:lambda:path/{service_api}, where {region} is the same as the region hosting the Lambda function, path indicates that the remaining substring in the URI should be treated as the path to the resource, including the initial /. For Lambda functions, this is usually of the form /2015-03-31/functions/[FunctionARN]/invocations. Defaults to None.
        authorizer_credentials(str, optional): Specifies the required credentials as an IAM role for API Gateway to invoke the authorizer. To specify an IAM role for API Gateway to assume, use the role's Amazon Resource Name (ARN). To use resource-based permissions on the Lambda function, specify null. Defaults to None.
        identity_source(str, optional): The identity source for which authorization is requested. For a TOKEN or COGNITO_USER_POOLS authorizer, this is required and specifies the request header mapping expression for the custom header holding the authorization token submitted by the client. For example, if the token header name is Auth, the header mapping expression is method.request.header.Auth.For the REQUEST authorizer, this is required when authorization caching is enabled. The value is a comma-separated string of one or more mapping expressions of the specified request parameters. For example, if an Auth header, a Name query string parameter are defined as identity sources, this value is method.request.header.Auth, method.request.querystring.Name. These parameters will be used to derive the authorization caching key and to perform runtime validation of the REQUEST authorizer by verifying all of the identity-related request parameters are present, not null and non-empty. Only when this is true does the authorizer invoke the authorizer Lambda function, otherwise, it returns a 401 Unauthorized response without calling the Lambda function. The valid value is a string of comma-separated mapping expressions of the specified request parameters. When the authorization caching is not enabled, this property is optional. Defaults to None.
        identity_validation_expression(str, optional): A validation expression for the incoming identity token. For TOKEN authorizers, this value is a regular expression. For COGNITO_USER_POOLS authorizers, API Gateway will match the aud field of the incoming token from the client against the specified regular expression. It will invoke the authorizer's Lambda function when there is a match. Otherwise, it will return a 401 Unauthorized response without calling the Lambda function. The validation expression does not apply to the REQUEST authorizer. Defaults to None.
        authorizer_result_ttl_in_seconds(int, optional): The TTL in seconds of cached authorizer results. If it equals 0, authorization caching is disabled. If it is greater than 0, API Gateway will cache authorizer responses. If this field is not set, the default value is 300. The maximum value is 3600, or 1 hour. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.authorizer.create(
                ctx, rest_api_id=value, name=value, type_=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.authorizer.create rest_api_id=value, name=value, type_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="create_authorizer",
        op_kwargs={
            "restApiId": rest_api_id,
            "name": name,
            "type": type_,
            "providerARNs": provider_ar_ns,
            "authType": auth_type,
            "authorizerUri": authorizer_uri,
            "authorizerCredentials": authorizer_credentials,
            "identitySource": identity_source,
            "identityValidationExpression": identity_validation_expression,
            "authorizerResultTtlInSeconds": authorizer_result_ttl_in_seconds,
        },
    )


async def delete(hub, ctx, rest_api_id: str, authorizer_id: str) -> None:
    r"""
    **Autogenerated function**

    Deletes an existing Authorizer resource. AWS CLI

    Args:
        rest_api_id(str): [Required] The string identifier of the associated RestApi.
        authorizer_id(str): [Required] The identifier of the Authorizer resource.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.authorizer.delete(
                ctx, rest_api_id=value, authorizer_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.authorizer.delete rest_api_id=value, authorizer_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="delete_authorizer",
        op_kwargs={"restApiId": rest_api_id, "authorizerId": authorizer_id},
    )


async def get(hub, ctx, rest_api_id: str, authorizer_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Describe an existing Authorizer resource. AWS CLI

    Args:
        rest_api_id(str): [Required] The string identifier of the associated RestApi.
        authorizer_id(str): [Required] The identifier of the Authorizer resource.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.authorizer.get(
                ctx, rest_api_id=value, authorizer_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.authorizer.get rest_api_id=value, authorizer_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="get_authorizer",
        op_kwargs={"restApiId": rest_api_id, "authorizerId": authorizer_id},
    )


async def get_all(
    hub, ctx, rest_api_id: str, position: str = None, limit: int = None
) -> Dict:
    r"""
    **Autogenerated function**

    Describe an existing Authorizers resource. AWS CLI

    Args:
        rest_api_id(str): [Required] The string identifier of the associated RestApi.
        position(str, optional): The current pagination position in the paged result set. Defaults to None.
        limit(int, optional): The maximum number of returned results per page. The default value is 25 and the maximum value is 500. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.authorizer.get_all(ctx, rest_api_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.authorizer.get_all rest_api_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="get_authorizers",
        op_kwargs={"restApiId": rest_api_id, "position": position, "limit": limit},
    )


async def update(
    hub, ctx, rest_api_id: str, authorizer_id: str, patch_operations: List = None
) -> Dict:
    r"""
    **Autogenerated function**

    Updates an existing Authorizer resource. AWS CLI

    Args:
        rest_api_id(str): [Required] The string identifier of the associated RestApi.
        authorizer_id(str): [Required] The identifier of the Authorizer resource.
        patch_operations(List, optional): A list of update operations to be applied to the specified resource and in the order specified in this list. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.authorizer.update(
                ctx, rest_api_id=value, authorizer_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.authorizer.update rest_api_id=value, authorizer_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="update_authorizer",
        op_kwargs={
            "restApiId": rest_api_id,
            "authorizerId": authorizer_id,
            "patchOperations": patch_operations,
        },
    )
