"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


__func_alias__ = {"import_": "import"}


async def create(
    hub,
    ctx,
    name: str = None,
    description: str = None,
    enabled: bool = None,
    generate_distinct_id: bool = None,
    value: str = None,
    stage_keys: List = None,
    customer_id: str = None,
    tags: Dict = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Create an ApiKey resource.  AWS CLI

    Args:
        name(str, optional): The name of the ApiKey. Defaults to None.
        description(str, optional): The description of the ApiKey. Defaults to None.
        enabled(bool, optional): Specifies whether the ApiKey can be used by callers. Defaults to None.
        generate_distinct_id(bool, optional): Specifies whether (true) or not (false) the key identifier is distinct from the created API key value. This parameter is deprecated and should not be used. Defaults to None.
        value(str, optional): Specifies a value of the API key. Defaults to None.
        stage_keys(List, optional): DEPRECATED FOR USAGE PLANS - Specifies stages associated with the API key. Defaults to None.
        customer_id(str, optional): An AWS Marketplace customer identifier , when integrating with the AWS SaaS Marketplace. Defaults to None.
        tags(Dict, optional): The key-value map of strings. The valid character set is [a-zA-Z+-=._:/]. The tag key can be up to 128 characters and must not start with aws:. The tag value can be up to 256 characters. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.api_key.create(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.api_key.create
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="create_api_key",
        op_kwargs={
            "name": name,
            "description": description,
            "enabled": enabled,
            "generateDistinctId": generate_distinct_id,
            "value": value,
            "stageKeys": stage_keys,
            "customerId": customer_id,
            "tags": tags,
        },
    )


async def delete(hub, ctx, api_key: str) -> None:
    r"""
    **Autogenerated function**

    Deletes the ApiKey resource.

    Args:
        api_key(str): [Required] The identifier of the ApiKey resource to be deleted.
    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.api_key.delete(ctx, api_key=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.api_key.delete api_key=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="delete_api_key",
        op_kwargs={"apiKey": api_key},
    )


async def get(hub, ctx, api_key: str, include_value: bool = None) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about the current ApiKey resource.

    Args:
        api_key(str): [Required] The identifier of the ApiKey resource.
        include_value(bool, optional): A boolean flag to specify whether (true) or not (false) the result contains the key value. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.api_key.get(ctx, api_key=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.api_key.get api_key=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="get_api_key",
        op_kwargs={"apiKey": api_key, "includeValue": include_value},
    )


async def get_all(
    hub,
    ctx,
    position: str = None,
    limit: int = None,
    name_query: str = None,
    customer_id: str = None,
    include_values: bool = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about the current ApiKeys resource.

    Args:
        position(str, optional): The current pagination position in the paged result set. Defaults to None.
        limit(int, optional): The maximum number of returned results per page. The default value is 25 and the maximum value is 500. Defaults to None.
        name_query(str, optional): The name of queried API keys. Defaults to None.
        customer_id(str, optional): The identifier of a customer in AWS Marketplace or an external system, such as a developer portal. Defaults to None.
        include_values(bool, optional): A boolean flag to specify whether (true) or not (false) the result contains key values. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.api_key.get_all(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.api_key.get_all
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="get_api_keys",
        op_kwargs={
            "position": position,
            "limit": limit,
            "nameQuery": name_query,
            "customerId": customer_id,
            "includeValues": include_values,
        },
    )


async def import_(
    hub, ctx, body: bytes, format_: str, fail_on_warnings: bool = None
) -> Dict:
    r"""
    **Autogenerated function**

    Import API keys from an external source, such as a CSV-formatted file.

    Args:
        body(bytes): The payload of the POST request to import API keys. For the payload format, see API Key File Format.
        format_(str): A query parameter to specify the input format to imported API keys. Currently, only the csv format is supported.
        fail_on_warnings(bool, optional): A query parameter to indicate whether to rollback ApiKey importation (true) or not (false) when error is encountered. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.api_key.import(ctx, body=value, format_=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.api_key.import body=value, format_=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="import_api_keys",
        op_kwargs={"body": body, "format": format_, "failOnWarnings": fail_on_warnings},
    )


async def update(hub, ctx, api_key: str, patch_operations: List = None) -> Dict:
    r"""
    **Autogenerated function**

    Changes information about an ApiKey resource.

    Args:
        api_key(str): [Required] The identifier of the ApiKey resource to be updated.
        patch_operations(List, optional): A list of update operations to be applied to the specified resource and in the order specified in this list. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.api_key.update(ctx, api_key=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.api_key.update api_key=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="update_api_key",
        op_kwargs={"apiKey": api_key, "patchOperations": patch_operations},
    )
