"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict
from typing import List


async def get(hub, ctx) -> Dict:
    r"""
    **Autogenerated function**

    Gets information about the current Account resource.


    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.account.get(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.account.get
    """
    return await hub.tool.aws.client.exec(
        ctx, service_name="apigateway", operation="get_account", op_kwargs={}
    )


async def update(hub, ctx, patch_operations: List = None) -> Dict:
    r"""
    **Autogenerated function**

    Changes information about the current Account resource.

    Args:
        patch_operations(List, optional): A list of update operations to be applied to the specified resource and in the order specified in this list. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.apigateway.account.update(ctx)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.apigateway.account.update
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="apigateway",
        operation="update_account",
        op_kwargs={"patchOperations": patch_operations},
    )
