"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def get(
    hub, ctx, app_id: str, backend_environment_name: str, job_id: str
) -> Dict:
    r"""
    **Autogenerated function**

    Returns information about a specific job.

    Args:
        app_id(str): The app ID.
        backend_environment_name(str): The name of the backend environment.
        job_id(str): The ID for the job.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.amplifybackend.backend.job.get(
                ctx, app_id=value, backend_environment_name=value, job_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.amplifybackend.backend.job.get app_id=value, backend_environment_name=value, job_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="amplifybackend",
        operation="get_backend_job",
        op_kwargs={
            "AppId": app_id,
            "BackendEnvironmentName": backend_environment_name,
            "JobId": job_id,
        },
    )


async def list_all(
    hub,
    ctx,
    app_id: str,
    backend_environment_name: str,
    job_id: str = None,
    max_results: int = None,
    next_token: str = None,
    operation: str = None,
    status: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Lists the jobs for the backend of an Amplify app.

    Args:
        app_id(str): The app ID.
        backend_environment_name(str): The name of the backend environment.
        job_id(str, optional): The ID for the job. Defaults to None.
        max_results(int, optional): The maximum number of results that you want in the response. Defaults to None.
        next_token(str, optional): The token for the next set of results. Defaults to None.
        operation(str, optional): Filters the list of response objects to include only those with the specified operation name. Defaults to None.
        status(str, optional): Filters the list of response objects to include only those with the specified status. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.amplifybackend.backend.job.list_all(
                ctx, app_id=value, backend_environment_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.amplifybackend.backend.job.list_all app_id=value, backend_environment_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="amplifybackend",
        operation="list_backend_jobs",
        op_kwargs={
            "AppId": app_id,
            "BackendEnvironmentName": backend_environment_name,
            "JobId": job_id,
            "MaxResults": max_results,
            "NextToken": next_token,
            "Operation": operation,
            "Status": status,
        },
    )


async def update(
    hub,
    ctx,
    app_id: str,
    backend_environment_name: str,
    job_id: str,
    operation: str = None,
    status: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates a specific job.

    Args:
        app_id(str): The app ID.
        backend_environment_name(str): The name of the backend environment.
        job_id(str): The ID for the job.
        operation(str, optional): Filters the list of response objects to include only those with the specified operation name. Defaults to None.
        status(str, optional): Filters the list of response objects to include only those with the specified status. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.amplifybackend.backend.job.update(
                ctx, app_id=value, backend_environment_name=value, job_id=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.amplifybackend.backend.job.update app_id=value, backend_environment_name=value, job_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="amplifybackend",
        operation="update_backend_job",
        op_kwargs={
            "AppId": app_id,
            "BackendEnvironmentName": backend_environment_name,
            "JobId": job_id,
            "Operation": operation,
            "Status": status,
        },
    )
