"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def clone(
    hub, ctx, app_id: str, backend_environment_name: str, target_environment_name: str
) -> Dict:
    r"""
    **Autogenerated function**

    This operation clones an existing backend.

    Args:
        app_id(str): The app ID.
        backend_environment_name(str): The name of the backend environment.
        target_environment_name(str): The name of the destination backend environment to be created.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.amplifybackend.backend.init.clone(
                ctx, app_id=value, backend_environment_name=value, target_environment_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.amplifybackend.backend.init.clone app_id=value, backend_environment_name=value, target_environment_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="amplifybackend",
        operation="clone_backend",
        op_kwargs={
            "AppId": app_id,
            "BackendEnvironmentName": backend_environment_name,
            "TargetEnvironmentName": target_environment_name,
        },
    )


async def create(
    hub,
    ctx,
    app_id: str,
    app_name: str,
    backend_environment_name: str,
    resource_config: Dict = None,
    resource_name: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    This operation creates a backend for an Amplify app. Backends are automatically created at the time of app creation.

    Args:
        app_id(str): The app ID.
        app_name(str): The name of the app.
        backend_environment_name(str): The name of the backend environment.
        resource_config(Dict, optional): The resource configuration for the create backend request. Defaults to None.
        resource_name(str, optional): The name of the resource. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.amplifybackend.backend.init.create(
                ctx, app_id=value, app_name=value, backend_environment_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.amplifybackend.backend.init.create app_id=value, app_name=value, backend_environment_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="amplifybackend",
        operation="create_backend",
        op_kwargs={
            "AppId": app_id,
            "AppName": app_name,
            "BackendEnvironmentName": backend_environment_name,
            "ResourceConfig": resource_config,
            "ResourceName": resource_name,
        },
    )


async def delete(hub, ctx, app_id: str, backend_environment_name: str) -> Dict:
    r"""
    **Autogenerated function**

    Removes an existing environment from your Amplify project.

    Args:
        app_id(str): The app ID.
        backend_environment_name(str): The name of the backend environment.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.amplifybackend.backend.init.delete(
                ctx, app_id=value, backend_environment_name=value
            )

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.amplifybackend.backend.init.delete app_id=value, backend_environment_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="amplifybackend",
        operation="delete_backend",
        op_kwargs={"AppId": app_id, "BackendEnvironmentName": backend_environment_name},
    )


async def get(hub, ctx, app_id: str, backend_environment_name: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Provides project-level details for your Amplify UI project.

    Args:
        app_id(str): The app ID.
        backend_environment_name(str, optional): The name of the backend environment. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.amplifybackend.backend.init.get(ctx, app_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.amplifybackend.backend.init.get app_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="amplifybackend",
        operation="get_backend",
        op_kwargs={"AppId": app_id, "BackendEnvironmentName": backend_environment_name},
    )
