"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


async def create(hub, ctx, app_id: str, backend_manager_app_id: str = None) -> Dict:
    r"""
    **Autogenerated function**

    Creates a config object for a backend.

    Args:
        app_id(str): The app ID.
        backend_manager_app_id(str, optional): The app ID for the backend manager. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.amplifybackend.backend.config.create(ctx, app_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.amplifybackend.backend.config.create app_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="amplifybackend",
        operation="create_backend_config",
        op_kwargs={"AppId": app_id, "BackendManagerAppId": backend_manager_app_id},
    )


async def remove(hub, ctx, app_id: str) -> Dict:
    r"""
    **Autogenerated function**

    Removes the AWS resources required to access the Amplify Admin UI.

    Args:
        app_id(str): The app ID.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.amplifybackend.backend.config.remove(ctx, app_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.amplifybackend.backend.config.remove app_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="amplifybackend",
        operation="remove_backend_config",
        op_kwargs={"AppId": app_id},
    )


async def update(hub, ctx, app_id: str, login_auth_config: Dict = None) -> Dict:
    r"""
    **Autogenerated function**

    Updates the AWS resources required to access the Amplify Admin UI.

    Args:
        app_id(str): The app ID.
        login_auth_config(Dict, optional): Describes the Amazon Cognito configuration for Admin UI access. Defaults to None.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.amplifybackend.backend.config.update(ctx, app_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.amplifybackend.backend.config.update app_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="amplifybackend",
        operation="update_backend_config",
        op_kwargs={"AppId": app_id, "LoginAuthConfig": login_auth_config},
    )
