"""
Autogenerated module using `pop-create-idem <https://gitlab.com/saltstack/pop/pop-create-idem>`__
"""
from typing import Dict


__func_alias__ = {"import_": "import"}


async def create(
    hub,
    ctx,
    app_id: str,
    backend_environment_name: str,
    resource_config: Dict,
    resource_name: str,
) -> Dict:
    r"""
    **Autogenerated function**

    Creates a new backend authentication resource.

    Args:
        app_id(str): The app ID.
        backend_environment_name(str): The name of the backend environment.
        resource_config(Dict): The resource configuration for this request object.
        resource_name(str): The name of this resource.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.amplifybackend.backend.auth.create(ctx, app_id=value, backend_environment_name=value, resource_config=value, resource_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.amplifybackend.backend.auth.create app_id=value, backend_environment_name=value, resource_config=value, resource_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="amplifybackend",
        operation="create_backend_auth",
        op_kwargs={
            "AppId": app_id,
            "BackendEnvironmentName": backend_environment_name,
            "ResourceConfig": resource_config,
            "ResourceName": resource_name,
        },
    )


async def delete(
    hub, ctx, app_id: str, backend_environment_name: str, resource_name: str
) -> Dict:
    r"""
    **Autogenerated function**

    Deletes an existing backend authentication resource.

    Args:
        app_id(str): The app ID.
        backend_environment_name(str): The name of the backend environment.
        resource_name(str): The name of this resource.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.amplifybackend.backend.auth.delete(ctx, app_id=value, backend_environment_name=value, resource_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.amplifybackend.backend.auth.delete app_id=value, backend_environment_name=value, resource_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="amplifybackend",
        operation="delete_backend_auth",
        op_kwargs={
            "AppId": app_id,
            "BackendEnvironmentName": backend_environment_name,
            "ResourceName": resource_name,
        },
    )


async def get(
    hub, ctx, app_id: str, backend_environment_name: str, resource_name: str
) -> Dict:
    r"""
    **Autogenerated function**

    Gets a backend auth details.

    Args:
        app_id(str): The app ID.
        backend_environment_name(str): The name of the backend environment.
        resource_name(str): The name of this resource.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.amplifybackend.backend.auth.get(ctx, app_id=value, backend_environment_name=value, resource_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.amplifybackend.backend.auth.get app_id=value, backend_environment_name=value, resource_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="amplifybackend",
        operation="get_backend_auth",
        op_kwargs={
            "AppId": app_id,
            "BackendEnvironmentName": backend_environment_name,
            "ResourceName": resource_name,
        },
    )


async def import_(
    hub,
    ctx,
    app_id: str,
    backend_environment_name: str,
    native_client_id: str,
    user_pool_id: str,
    web_client_id: str,
    identity_pool_id: str = None,
) -> Dict:
    r"""
    **Autogenerated function**

    Imports an existing backend authentication resource.

    Args:
        app_id(str): The app ID.
        backend_environment_name(str): The name of the backend environment.
        identity_pool_id(str, optional): The ID of the Amazon Cognito identity pool. Defaults to None.
        native_client_id(str): The ID of the Amazon Cognito native client.
        user_pool_id(str): The ID of the Amazon Cognito user pool.
        web_client_id(str): The ID of the Amazon Cognito web client.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.amplifybackend.backend.auth.import(ctx, app_id=value, backend_environment_name=value, native_client_id=value, user_pool_id=value, web_client_id=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.amplifybackend.backend.auth.import app_id=value, backend_environment_name=value, native_client_id=value, user_pool_id=value, web_client_id=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="amplifybackend",
        operation="import_backend_auth",
        op_kwargs={
            "AppId": app_id,
            "BackendEnvironmentName": backend_environment_name,
            "IdentityPoolId": identity_pool_id,
            "NativeClientId": native_client_id,
            "UserPoolId": user_pool_id,
            "WebClientId": web_client_id,
        },
    )


async def update(
    hub,
    ctx,
    app_id: str,
    backend_environment_name: str,
    resource_config: Dict,
    resource_name: str,
) -> Dict:
    r"""
    **Autogenerated function**

    Updates an existing backend authentication resource.

    Args:
        app_id(str): The app ID.
        backend_environment_name(str): The name of the backend environment.
        resource_config(Dict): The resource configuration for this request object.
        resource_name(str): The name of this resource.

    Returns:
        Dict

    Examples:
        Call from code:

        .. code-block:: python

            await hub.exec.aws_auto.amplifybackend.backend.auth.update(ctx, app_id=value, backend_environment_name=value, resource_config=value, resource_name=value)

        Call from CLI:

        .. code-block:: bash

            $ idem exec aws_auto.amplifybackend.backend.auth.update app_id=value, backend_environment_name=value, resource_config=value, resource_name=value
    """
    return await hub.tool.aws.client.exec(
        ctx,
        service_name="amplifybackend",
        operation="update_backend_auth",
        op_kwargs={
            "AppId": app_id,
            "BackendEnvironmentName": backend_environment_name,
            "ResourceConfig": resource_config,
            "ResourceName": resource_name,
        },
    )
